/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.oauth;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jboss.seam.social.Current;
import org.jboss.seam.social.JsonMapper;
import org.jboss.seam.social.SeamSocialExtension;
import org.jboss.seam.social.UserProfile;
import org.jboss.seam.social.event.OAuthComplete;
import org.jboss.seam.social.event.SocialEvent;
import org.jboss.seam.social.exception.SeamSocialException;
import org.jboss.seam.social.oauth.OAuthProvider;
import org.jboss.seam.social.oauth.OAuthRequest;
import org.jboss.seam.social.oauth.OAuthService;
import org.jboss.seam.social.oauth.OAuthSession;
import org.jboss.seam.social.oauth.OAuthToken;
import org.jboss.seam.social.rest.RestResponse;
import org.jboss.seam.social.rest.RestVerb;
import org.jboss.seam.social.utils.URLUtils;
import org.jboss.solder.logging.Logger;

public class OAuthServiceImpl
implements OAuthService {
    private static final long serialVersionUID = -8423894021913341674L;
    private static Annotation currentLiteral = new AnnotationLiteral<Current>(){
        private static final long serialVersionUID = -2929657732814790025L;
    };
    @Inject
    @Any
    private Instance<OAuthProvider> providers;
    @Inject
    @Any
    private Event<OAuthComplete> completeEventProducer;
    private Annotation qualifier;
    private Map<String, String> requestHeader;
    @Inject
    protected JsonMapper jsonService;
    @Inject
    private Logger log;
    @Inject
    @Any
    protected Instance<OAuthSession> sessionInstances;
    @Inject
    protected SeamSocialExtension socialConfig;
    private String type;

    void setQualifier(Annotation qualifier) {
        this.qualifier = qualifier;
    }

    public String getType() {
        if (StringUtils.isEmpty((CharSequence)this.type)) {
            this.type = (String)SeamSocialExtension.getServicesToQualifier().get((Object)this.getQualifier());
        }
        return this.type;
    }

    public String getAuthorizationUrl() {
        return this.getProvider().getAuthorizationUrl(this.getRequestToken());
    }

    private OAuthProvider getProvider() {
        return (OAuthProvider)this.providers.select(new Annotation[]{this.getQualifier()}).get();
    }

    protected OAuthToken getRequestToken() {
        OAuthSession session = this.getSession();
        if (session.getRequestToken() == null) {
            session.setRequestToken(this.getProvider().getRequestToken());
        }
        return session.getRequestToken();
    }

    public synchronized void initAccessToken() {
        OAuthSession session = this.getSession();
        if (session.getAccessToken() == null) {
            session.setAccessToken(this.getProvider().getAccessToken(this.getRequestToken(), session.getVerifier()));
        }
        if (session.getAccessToken() != null) {
            session.setRequestToken(null);
            this.log.debug((Object)("firing event for " + this.getQualifier() + " OAuth complete cycle"));
            Event event = this.completeEventProducer.select(new Annotation[]{this.getQualifier()});
            event.fire((Object)new OAuthComplete(SocialEvent.Status.SUCCESS, "", session));
            this.log.debug((Object)"After OAuth cycle completion");
        }
    }

    public void resetConnection() {
        OAuthSession session = this.getSession();
        session.setAccessToken(null);
        session.setVerifier(null);
        session.setUserProfile(null);
    }

    public RestResponse sendSignedRequest(OAuthRequest request) {
        if (this.getRequestHeader() != null) {
            request.getHeaders().putAll(this.getRequestHeader());
        }
        this.getProvider().signRequest(this.getAccessToken(), request);
        return request.send();
    }

    public RestResponse sendSignedRequest(RestVerb verb, String uri) {
        OAuthRequest request = this.getProvider().requestFactory(verb, uri);
        return this.sendSignedRequest(request);
    }

    public RestResponse sendSignedRequest(RestVerb verb, String uri, String key, Object value) {
        OAuthRequest request = this.getProvider().requestFactory(verb, uri);
        request.addBodyParameter(key, value.toString());
        return this.sendSignedRequest(request);
    }

    public RestResponse sendSignedXmlRequest(RestVerb verb, String uri, String payload) {
        OAuthRequest request = this.getProvider().requestFactory(verb, uri);
        request.addPayload(payload);
        return this.sendSignedRequest(request);
    }

    public RestResponse sendSignedRequest(RestVerb verb, String uri, Map<String, ? extends Object> params) {
        OAuthRequest request = this.getProvider().requestFactory(verb, uri);
        for (Map.Entry<String, ? extends Object> ent : params.entrySet()) {
            request.addBodyParameter(ent.getKey(), ent.getValue().toString());
        }
        return this.sendSignedRequest(request);
    }

    public void setVerifier(String verifierStr) {
        OAuthSession session = this.getSession();
        session.setVerifier(verifierStr);
    }

    public String getVerifier() {
        OAuthSession session = this.getSession();
        return session.getVerifier();
    }

    public OAuthToken getAccessToken() {
        OAuthSession session = this.getSession();
        return session.getAccessToken();
    }

    public boolean isConnected() {
        return this.getSession().isConnected();
    }

    public void requireAuthorization() {
        if (!this.isConnected()) {
            throw new SeamSocialException("This action requires an OAuth connexion");
        }
    }

    public void setAccessToken(String token, String secret) {
        OAuthSession session = this.getSession();
        session.setAccessToken(this.getProvider().tokenFactory(token, secret));
    }

    public void setAccessToken(OAuthToken token) {
        OAuthSession session = this.getSession();
        session.setAccessToken(token);
    }

    public UserProfile getMyProfile() {
        return this.getSession().getUserProfile();
    }

    public OAuthSession getSession() {
        OAuthSession session = this.socialConfig.isMultiSession() ? (OAuthSession)this.sessionInstances.select(new Annotation[]{currentLiteral}).get() : (OAuthSession)this.sessionInstances.select(new Annotation[]{this.getQualifier()}).get();
        return session;
    }

    public <T> T getForObject(String uri, Class<T> clazz) {
        return (T)this.jsonService.mapToObject(this.sendSignedRequest(RestVerb.GET, uri), clazz);
    }

    public <T> T getForObject(String uri, Class<T> clazz, Map<String, ? extends Object> params) {
        return (T)this.jsonService.mapToObject(this.sendSignedRequest(RestVerb.GET, uri, params), clazz);
    }

    public <T> T getForObject(String uri, Class<T> clazz, Object ... urlParams) {
        String url = MessageFormat.format(uri, urlParams);
        return (T)this.jsonService.mapToObject(this.sendSignedRequest(RestVerb.GET, url), clazz);
    }

    public <T> T postForObject(String uri, Map<String, ? extends Object> params, Class<T> clazz) {
        OAuthRequest request = this.getProvider().requestFactory(RestVerb.POST, uri);
        request.addBodyParameters(params);
        return (T)this.jsonService.mapToObject(this.sendSignedRequest(request), clazz);
    }

    public String postForLocation(String uri, Object toPost, Object ... urlParams) {
        uri = MessageFormat.format(uri, urlParams);
        OAuthRequest request = this.getProvider().requestFactory(RestVerb.POST, uri);
        request.addPayload(this.jsonService.ObjectToJsonString(toPost));
        RestResponse response = this.sendSignedRequest(request);
        return response.getHeader("Location");
    }

    public String postForLocation(String uri, Object toPost, Map<String, String> queryStringData, Object ... urlParams) {
        if (queryStringData != null && !queryStringData.isEmpty()) {
            String encodedParams = URLUtils.doFormUrlEncode(queryStringData);
            uri = uri.indexOf(63) == uri.length() - 1 ? uri + encodedParams : (uri.indexOf(63) == -1 ? uri + "?" + encodedParams : uri + "&" + encodedParams);
        }
        return this.postForLocation(uri, toPost, new Object[0]);
    }

    public void put(String uri, Object toPut, Object ... urlParams) {
        uri = MessageFormat.format(uri, urlParams);
        OAuthRequest request = this.getProvider().requestFactory(RestVerb.PUT, uri);
        request.addPayload(this.jsonService.ObjectToJsonString(toPut));
        this.sendSignedRequest(request);
    }

    public void delete(String uri) {
        this.sendSignedRequest(RestVerb.DELETE, uri);
    }

    public Annotation getQualifier() {
        return this.qualifier;
    }

    public Map<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(Map<String, String> requestHeader) {
        this.requestHeader = requestHeader;
    }
}

