/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.oauth;

import java.lang.annotation.Annotation;
import org.jboss.seam.social.SeamSocialExtension;
import org.jboss.seam.social.UserProfile;
import org.jboss.seam.social.oauth.OAuthSession;
import org.jboss.seam.social.oauth.OAuthToken;

public class OAuthSessionImpl
implements OAuthSession {
    private static final long serialVersionUID = -2526192334215289830L;
    private OAuthToken requestToken;
    private OAuthToken accessToken;
    private String verifier;
    private UserProfile userProfile;
    private Annotation serviceQualifier;
    private String serviceName;

    public OAuthSessionImpl(Annotation qualifier) {
        this.serviceQualifier = qualifier;
        this.serviceName = (String)SeamSocialExtension.getServicesToQualifier().get((Object)qualifier);
    }

    public OAuthToken getRequestToken() {
        return this.requestToken;
    }

    public void setRequestToken(OAuthToken requestToken) {
        this.requestToken = requestToken;
    }

    public OAuthToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(OAuthToken accessToken) {
        this.accessToken = accessToken;
    }

    public String getVerifier() {
        return this.verifier;
    }

    public void setVerifier(String verifier) {
        this.verifier = verifier;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userProfile == null ? 0 : this.userProfile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthSessionImpl other = (OAuthSessionImpl)obj;
        return !(this.userProfile == null ? other.userProfile != null : !this.userProfile.equals((Object)other.userProfile));
    }

    public Annotation getServiceQualifier() {
        return this.serviceQualifier;
    }

    public String toString() {
        return this.serviceName + " - " + (this.isConnected() ? this.getUserProfile().getFullName() : "not connected");
    }

    public boolean isConnected() {
        return this.accessToken != null;
    }

    public String getName() {
        return this.toString();
    }
}

