/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.scribe;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.seam.social.exception.SeamSocialRestException;
import org.jboss.seam.social.oauth.OAuthRequest;
import org.jboss.seam.social.rest.RestParameterList;
import org.jboss.seam.social.rest.RestResponse;
import org.jboss.seam.social.rest.RestVerb;
import org.jboss.seam.social.scribe.ParameterListScribe;
import org.jboss.seam.social.scribe.RestResponseScribe;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Verb;

public class OAuthRequestScribe
implements OAuthRequest {
    private static final long serialVersionUID = 6560621737726192278L;
    private final org.scribe.model.OAuthRequest request;

    org.scribe.model.OAuthRequest getDelegate() {
        return this.request;
    }

    OAuthRequestScribe(org.scribe.model.OAuthRequest request) {
        this.request = request;
    }

    public OAuthRequestScribe(RestVerb verb, String url) {
        this.request = new org.scribe.model.OAuthRequest(Verb.valueOf((String)verb.toString()), url);
    }

    public void addOAuthParameter(String key, String value) {
        this.request.addOAuthParameter(key, value);
    }

    public RestResponse send() {
        RestResponseScribe resp = null;
        try {
            resp = new RestResponseScribe(this.request.send(), this.request.getUrl());
        }
        catch (OAuthException e) {
            throw new SeamSocialRestException(this.request.getUrl(), (Exception)((Object)e));
        }
        if (resp.getCode() >= 400) {
            throw new SeamSocialRestException(resp.getCode(), this.request.getUrl(), resp.getHeaders().toString());
        }
        return resp;
    }

    public Map<String, String> getOauthParameters() {
        return this.request.getOauthParameters();
    }

    public String toString() {
        return this.request.toString();
    }

    public int hashCode() {
        return this.request.hashCode();
    }

    public void addHeader(String key, String value) {
        this.request.addHeader(key, value);
    }

    public void addBodyParameter(String key, String value) {
        this.request.addBodyParameter(key, value);
    }

    public void addQuerystringParameter(String key, String value) {
        this.request.addQuerystringParameter(key, value);
    }

    public void addPayload(String payload) {
        this.request.addPayload(payload);
    }

    public RestParameterList getQueryStringParams() {
        return new ParameterListScribe(this.request.getQueryStringParams());
    }

    public boolean equals(Object obj) {
        return this.request.equals(obj);
    }

    public RestParameterList getBodyParams() {
        return new ParameterListScribe(this.request.getBodyParams());
    }

    public String getUrl() {
        return this.request.getUrl();
    }

    public String getSanitizedUrl() {
        return this.request.getSanitizedUrl();
    }

    public String getBodyContents() {
        return this.request.getBodyContents();
    }

    public RestVerb getVerb() {
        return RestVerb.valueOf((String)this.request.getVerb().toString());
    }

    public Map<String, String> getHeaders() {
        return this.request.getHeaders();
    }

    public void setConnectTimeout(int duration, TimeUnit unit) {
        this.request.setConnectTimeout(duration, unit);
    }

    public void setReadTimeout(int duration, TimeUnit unit) {
        this.request.setReadTimeout(duration, unit);
    }

    public String getCompleteUrl() {
        return this.request.getCompleteUrl();
    }

    public void addPayload(byte[] payload) {
        this.request.addPayload(payload);
    }

    public String getCharset() {
        return this.request.getCharset();
    }

    public void setCharset(String charsetName) {
        this.request.setCharset(charsetName);
    }

    public void setConnectionKeepAlive(boolean connectionKeepAlive) {
        this.request.setConnectionKeepAlive(connectionKeepAlive);
    }

    public void addBodyParameters(Map<String, ? extends Object> toAdd) {
        for (String key : toAdd.keySet()) {
            this.addBodyParameter(key, toAdd.get(key).toString());
        }
    }
}

