/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.utils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanMap;
import org.jboss.seam.social.exception.SeamSocialException;

public class URLUtils {
    private static final String EMPTY_STRING = "";
    private static final String UTF_8 = "UTF-8";
    private static final String PAIR_SEPARATOR = "=";
    private static final String PARAM_SEPARATOR = "&";
    private static final char MULTI_VALUE_SEPARATOR = ',';
    private static final char QUERY_STRING_SEPARATOR = '?';
    private static final String ERROR_MSG = String.format("Cannot find specified encoding: %s", "UTF-8");
    private static final Set<EncodingRule> ENCODING_RULES;
    public static Joiner commaJoiner;
    private static Joiner.MapJoiner queryMapJoiner;

    public static String formURLEncodeMap(Map<String, ? extends Object> parameters) {
        return parameters.size() <= 0 ? EMPTY_STRING : URLUtils.doFormUrlEncode(parameters);
    }

    public static String doFormUrlEncode(Map<String, ? extends Object> params) {
        Map urlEncodeMap = Maps.transformValues(params, (Function)new formUrlEncodeFunc());
        return queryMapJoiner.join(urlEncodeMap);
    }

    public static String percentEncode(String string) {
        String encoded = URLUtils.formURLEncode(string);
        for (EncodingRule rule : ENCODING_RULES) {
            encoded = rule.apply(encoded);
        }
        return encoded;
    }

    public static String formURLEncode(String string) {
        try {
            return URLEncoder.encode(string, UTF_8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(ERROR_MSG, uee);
        }
    }

    public static String formURLDecode(String string) {
        try {
            return URLDecoder.decode(string, UTF_8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(ERROR_MSG, uee);
        }
    }

    public static String buildUri(String url, Map<String, ? extends Object> parameters) {
        String queryString = URLUtils.formURLEncodeMap(parameters);
        if (queryString.equals(EMPTY_STRING)) {
            return url;
        }
        url = url + (url.indexOf(63) != -1 ? PARAM_SEPARATOR : Character.valueOf('?'));
        url = url + queryString;
        return url;
    }

    public static String buildUri(String url, Object pojo) {
        Multimap<String, Object> pojoMap = URLUtils.pojoToMultiMap(pojo);
        String queryString = URLUtils.formURLEncodeMap(pojoMap);
        if (queryString.equals(EMPTY_STRING)) {
            return url;
        }
        url = url + (url.indexOf(63) != -1 ? PARAM_SEPARATOR : Character.valueOf('?'));
        url = url + queryString;
        return url;
    }

    private static String formURLEncodeMap(Multimap<String, Object> parameters) {
        return parameters.size() <= 0 ? EMPTY_STRING : URLUtils.doFormUrlEncode(parameters);
    }

    private static String doFormUrlEncode(Multimap<String, Object> parameters) {
        Multimap urlEncodeMap = Multimaps.transformValues(parameters, (Function)new formUrlEncodeFunc());
        return queryMapJoiner.join((Iterable)urlEncodeMap.entries());
    }

    private static Multimap<String, Object> pojoToMultiMap(Object pojo) {
        BeanMap pojoMap = new BeanMap(pojo);
        HashMultimap res = HashMultimap.create();
        for (String key : pojoMap.keySet()) {
            if ("class".equals(key)) continue;
            Object value = pojoMap.get(key);
            if (value instanceof Map) {
                throw new IllegalArgumentException("Cannot convert Pojo containing a Map to a Multimap");
            }
            if (value instanceof Collection) {
                for (Object elt : (Collection)value) {
                    res.put((Object)key, elt);
                }
                continue;
            }
            res.put((Object)key, value);
        }
        return res;
    }

    public static String buildUri(String url, String key, String value) {
        if (EMPTY_STRING.equals(key) || key == null) {
            return url;
        }
        url = url + (url.indexOf(63) != -1 ? PARAM_SEPARATOR : Character.valueOf('?'));
        url = url + key + PAIR_SEPARATOR + URLUtils.formURLEncode(value);
        return url;
    }

    public static String concatSortedPercentEncodedParams(Map<String, String> params) {
        StringBuilder result = new StringBuilder();
        for (String key : params.keySet()) {
            result.append(key).append(PAIR_SEPARATOR);
            result.append(params.get(key)).append(PARAM_SEPARATOR);
        }
        return result.toString().substring(0, result.length() - 1);
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (queryString != null && queryString.length() > 0) {
            for (String param : queryString.split(PARAM_SEPARATOR)) {
                String[] pair = param.split(PAIR_SEPARATOR);
                String key = URLUtils.formURLDecode(pair[0]);
                String value = pair.length > 1 ? URLUtils.formURLDecode(pair[1]) : EMPTY_STRING;
                result.put(key, value);
            }
        }
        return result;
    }

    public static Map<String, String> buildPagingParametersWithCount(int page, int pageSize, long sinceId, long maxId) {
        HashMap parameters = Maps.newHashMap();
        parameters.put("page", String.valueOf(page));
        parameters.put("count", String.valueOf(pageSize));
        if (sinceId > 0L) {
            parameters.put("since_id", String.valueOf(sinceId));
        }
        if (maxId > 0L) {
            parameters.put("max_id", String.valueOf(maxId));
        }
        return parameters;
    }

    public static Map<String, String> buildPagingParametersWithPerPage(int page, int pageSize, long sinceId, long maxId) {
        HashMap parameters = Maps.newHashMap();
        parameters.put("page", String.valueOf(page));
        parameters.put("per_page", String.valueOf(pageSize));
        if (sinceId > 0L) {
            parameters.put("since_id", String.valueOf(sinceId));
        }
        if (maxId > 0L) {
            parameters.put("max_id", String.valueOf(maxId));
        }
        return parameters;
    }

    public static String processPlaceHolders(String in, Map<String, ? extends Object> values) {
        String out = new String(in);
        for (String key : values.keySet()) {
            String toLook = "{" + key + "}";
            String value = values.get(key).toString();
            try {
                out.replace(toLook, URLEncoder.encode(value, UTF_8));
            }
            catch (UnsupportedEncodingException e) {
                throw new SeamSocialException("unable to encode " + value, (Throwable)e);
            }
        }
        return out;
    }

    public static String processPlaceHolders(String in, Object pojo) {
        BeanMap paramMap = new BeanMap(pojo);
        return URLUtils.processPlaceHolders(in, (Map<String, ? extends Object>)paramMap);
    }

    static {
        commaJoiner = Joiner.on((char)',').skipNulls();
        queryMapJoiner = Joiner.on((String)PARAM_SEPARATOR).withKeyValueSeparator(PAIR_SEPARATOR);
        HashSet<EncodingRule> rules = new HashSet<EncodingRule>();
        rules.add(new EncodingRule("*", "%2A"));
        rules.add(new EncodingRule("+", "%20"));
        rules.add(new EncodingRule("%7E", "~"));
        ENCODING_RULES = Collections.unmodifiableSet(rules);
    }

    private static final class EncodingRule {
        private final String ch;
        private final String toCh;

        EncodingRule(String ch, String toCh) {
            this.ch = ch;
            this.toCh = toCh;
        }

        String apply(String string) {
            return string.replace(this.ch, this.toCh);
        }
    }

    private static class formUrlEncodeFunc
    implements Function<Object, String> {
        private formUrlEncodeFunc() {
        }

        public String apply(Object input) {
            return URLUtils.formURLEncode(input.toString());
        }
    }
}

