/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Named;
import org.jboss.seam.solder.bean.ContextualLifecycle;
import org.jboss.seam.solder.bean.DelegatingContextualLifecycle;
import org.jboss.seam.solder.bean.DummyInjectionTarget;
import org.jboss.seam.solder.bean.ImmutableBean;
import org.jboss.seam.solder.bean.ImmutablePassivationCapableBean;
import org.jboss.seam.solder.literal.AnyLiteral;
import org.jboss.seam.solder.literal.DefaultLiteral;
import org.jboss.seam.solder.reflection.annotated.Annotateds;
import org.jboss.seam.solder.util.collections.Arrays2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanBuilder<T> {
    private final BeanManager beanManager;
    private Class<?> beanClass;
    private String name;
    private Set<Annotation> qualifiers;
    private Class<? extends Annotation> scope;
    private Set<Class<? extends Annotation>> stereotypes;
    private Set<Type> types;
    private Set<InjectionPoint> injectionPoints;
    private boolean alternative;
    private boolean nullable;
    private ContextualLifecycle<T> beanLifecycle;
    boolean passivationCapable;
    private String id;
    private String toString;

    public BeanBuilder(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public BeanBuilder<T> readFromType(AnnotatedType<T> type) {
        this.beanClass = type.getJavaClass();
        InjectionTarget injectionTarget = !type.getJavaClass().isInterface() ? this.beanManager.createInjectionTarget(type) : new DummyInjectionTarget();
        this.beanLifecycle = new DelegatingContextualLifecycle(injectionTarget);
        this.injectionPoints = injectionTarget.getInjectionPoints();
        this.qualifiers = new HashSet<Annotation>();
        this.stereotypes = new HashSet<Class<? extends Annotation>>();
        this.types = new HashSet<Type>();
        for (Annotation annotation : type.getAnnotations()) {
            if (this.beanManager.isQualifier(annotation.annotationType())) {
                this.qualifiers.add(annotation);
            } else if (this.beanManager.isScope(annotation.annotationType())) {
                this.scope = annotation.annotationType();
            } else if (this.beanManager.isStereotype(annotation.annotationType())) {
                this.stereotypes.add(annotation.annotationType());
            }
            if (annotation instanceof Named) {
                this.name = ((Named)annotation).value();
            }
            if (!(annotation instanceof Alternative)) continue;
            this.alternative = true;
        }
        if (this.scope == null) {
            this.scope = Dependent.class;
        }
        for (Class c = type.getJavaClass(); c != Object.class && c != null; c = c.getSuperclass()) {
            this.types.add(c);
        }
        for (Class<?> i : type.getJavaClass().getInterfaces()) {
            this.types.add(i);
        }
        if (this.qualifiers.isEmpty()) {
            this.qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
        }
        this.qualifiers.add((Annotation)AnyLiteral.INSTANCE);
        this.id = ImmutableBean.class.getName() + ":" + Annotateds.createTypeId(type);
        return this;
    }

    public Bean<T> create() {
        if (!this.passivationCapable) {
            return new ImmutableBean<T>(this.beanClass, this.name, this.qualifiers, this.scope, this.stereotypes, this.types, this.alternative, this.nullable, this.injectionPoints, this.beanLifecycle, this.toString);
        }
        return new ImmutablePassivationCapableBean<T>(this.id, this.beanClass, this.name, this.qualifiers, this.scope, this.stereotypes, this.types, this.alternative, this.nullable, this.injectionPoints, this.beanLifecycle, this.toString);
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public BeanBuilder<T> qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers = qualifiers;
        return this;
    }

    public BeanBuilder<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers = Arrays2.asSet(qualifiers);
        return this;
    }

    public BeanBuilder<T> addQualifier(Annotation qualifier) {
        this.qualifiers.add(qualifier);
        return this;
    }

    public BeanBuilder<T> addQualifiers(Annotation ... qualifiers) {
        this.qualifiers.addAll(Arrays2.asSet(qualifiers));
        return this;
    }

    public BeanBuilder<T> addQualifiers(Collection<Annotation> qualifiers) {
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public BeanBuilder<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public BeanBuilder<T> stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes = stereotypes;
        return this;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public BeanBuilder<T> types(Set<Type> types) {
        this.types = types;
        return this;
    }

    public BeanBuilder<T> types(Type ... types) {
        this.types = Arrays2.asSet(types);
        return this;
    }

    public BeanBuilder<T> addType(Type type) {
        this.types.add(type);
        return this;
    }

    public BeanBuilder<T> addTypes(Type ... types) {
        this.types.addAll(Arrays2.asSet(types));
        return this;
    }

    public BeanBuilder<T> addTypes(Collection<Type> types) {
        this.types.addAll(types);
        return this;
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public BeanBuilder<T> alternative(boolean alternative) {
        this.alternative = alternative;
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public BeanBuilder<T> nullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public ContextualLifecycle<T> getBeanLifecycle() {
        return this.beanLifecycle;
    }

    public BeanBuilder<T> beanLifecycle(ContextualLifecycle<T> beanLifecycle) {
        this.beanLifecycle = beanLifecycle;
        return this;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public BeanBuilder<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public String getName() {
        return this.name;
    }

    public BeanBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public boolean isPassivationCapable() {
        return this.passivationCapable;
    }

    public BeanBuilder<T> passivationCapable(boolean passivationCapable) {
        this.passivationCapable = passivationCapable;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public BeanBuilder<T> id(String id) {
        this.id = id;
        return this;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public BeanBuilder<T> injectionPoints(Set<InjectionPoint> injectionPoints) {
        this.injectionPoints = injectionPoints;
        return this;
    }

    public BeanBuilder<T> toString(String toString) {
        this.toString = toString;
        return this;
    }

    public String getToString() {
        return this.toString;
    }
}

