/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.bean.generic;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.inject.Inject;
import org.jboss.seam.solder.bean.BeanBuilder;
import org.jboss.seam.solder.bean.Beans;
import org.jboss.seam.solder.bean.ContextualLifecycle;
import org.jboss.seam.solder.bean.generic.ApplyScope;
import org.jboss.seam.solder.bean.generic.Generic;
import org.jboss.seam.solder.bean.generic.GenericConfiguration;
import org.jboss.seam.solder.bean.generic.GenericIdentifier;
import org.jboss.seam.solder.bean.generic.GenericManagedBean;
import org.jboss.seam.solder.bean.generic.GenericMarkerLiteral;
import org.jboss.seam.solder.bean.generic.GenericObserverMethod;
import org.jboss.seam.solder.bean.generic.GenericProducerField;
import org.jboss.seam.solder.bean.generic.GenericProducerMethod;
import org.jboss.seam.solder.bean.generic.GenericType;
import org.jboss.seam.solder.bean.generic.InjectGenericLiteral;
import org.jboss.seam.solder.literal.AnyLiteral;
import org.jboss.seam.solder.literal.DefaultLiteral;
import org.jboss.seam.solder.reflection.AnnotationInspector;
import org.jboss.seam.solder.reflection.Synthetic;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;
import org.jboss.seam.solder.reflection.annotated.AnnotationRedefiner;
import org.jboss.seam.solder.reflection.annotated.RedefinitionContext;
import org.jboss.seam.solder.unwraps.Unwraps;
import org.jboss.seam.solder.unwraps.UnwrapsProducerBean;
import org.jboss.seam.solder.util.collections.Arrays2;
import org.jboss.seam.solder.util.collections.Multimaps;
import org.jboss.seam.solder.util.collections.SetMultimap;
import org.jboss.seam.solder.util.collections.Supplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericBeanExtension
implements Extension {
    private final SetMultimap<Class<? extends Annotation>, BeanHolder<?>> genericBeans = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
    private final SetMultimap<Class<? extends Annotation>, ObserverMethodHolder<?, ?>> genericBeanObserverMethods;
    private final SetMultimap<Class<? extends Annotation>, ProducerMethodHolder<?, ?>> genericBeanProducerMethods = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
    private final SetMultimap<Class<? extends Annotation>, FieldHolder<?, ?>> genericBeanProducerFields;
    private final Map<AnnotatedType<?>, InjectionTarget<?>> genericInjectionTargets;
    private final Map<GenericIdentifier, GenericConfigurationHolder> genericConfigurationPoints;
    private final Map<AnnotatedMember<?>, Bean<?>> genericProducerBeans;
    private final SetMultimap<Class<? extends Annotation>, AnnotatedMethod<?>> unwrapsMethods;
    private final Synthetic.Provider annotatedMemberInjectionProvider;
    private final Synthetic genericBeanQualifier;
    private final Set<String> errors;
    private boolean beanDiscoveryOver = false;

    private static <T> Supplier<Set<T>> createHashSetSupplier() {
        return new Supplier<Set<T>>(){

            @Override
            public Set<T> get() {
                return new HashSet();
            }
        };
    }

    public GenericBeanExtension() {
        this.genericBeanObserverMethods = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
        this.genericBeanProducerFields = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
        this.genericInjectionTargets = new HashMap();
        this.genericConfigurationPoints = new HashMap<GenericIdentifier, GenericConfigurationHolder>();
        this.genericProducerBeans = new HashMap();
        this.unwrapsMethods = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
        this.genericBeanQualifier = new Synthetic.SyntheticLiteral("org.jboss.seam.solder.bean.generic.genericQualifier", 0L);
        this.errors = new HashSet<String>();
        this.annotatedMemberInjectionProvider = new Synthetic.Provider("org.jboss.seam.solder.bean.generic.annotatedMember");
    }

    <X> void replaceInjectOnGenericBeans(@Observes ProcessAnnotatedType<X> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(GenericConfiguration.class)) {
            Class<? extends Annotation> genericConfigurationType = ((GenericConfiguration)type.getAnnotation(GenericConfiguration.class)).value();
            if (!genericConfigurationType.isAnnotationPresent(GenericType.class)) {
                this.errors.add("Bean " + type.getJavaClass().getName() + " specifies generic annotation " + type.getAnnotation(GenericConfiguration.class) + " however " + genericConfigurationType + " is not annotated @GenericConfiguration.");
            } else {
                Class<?> configType = genericConfigurationType.getAnnotation(GenericType.class).value();
                if (configType.isAnnotationPresent(GenericConfiguration.class)) {
                    this.errors.add("Generic configuration type " + genericConfigurationType + " specifies a value() of " + configType + " however " + configType + " is a generic bean. Generic configuration types may not be generic beans");
                }
            }
            AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(type);
            builder.addToClass(this.genericBeanQualifier);
            builder.redefine(Inject.class, new AnnotationRedefiner<Inject>(){

                @Override
                public void redefine(RedefinitionContext<Inject> ctx) {
                    if (ctx.getAnnotatedElement() instanceof Field && ctx.getAnnotatedElement().isAnnotationPresent(Generic.class)) {
                        ctx.getAnnotationBuilder().remove(Inject.class).add(InjectGenericLiteral.INSTANCE);
                    }
                }
            });
            builder.redefine(Produces.class, new AnnotationRedefiner<Produces>(){

                @Override
                public void redefine(RedefinitionContext<Produces> ctx) {
                    ctx.getAnnotationBuilder().add(GenericMarkerLiteral.INSTANCE).add(GenericBeanExtension.this.genericBeanQualifier);
                }
            });
            builder.redefine(Disposes.class, new AnnotationRedefiner<Disposes>(){

                @Override
                public void redefine(RedefinitionContext<Disposes> ctx) {
                    ctx.getAnnotationBuilder().add(GenericMarkerLiteral.INSTANCE).add(GenericBeanExtension.this.genericBeanQualifier);
                }
            });
            builder.redefine(Generic.class, new AnnotationRedefiner<Generic>(){

                @Override
                public void redefine(RedefinitionContext<Generic> ctx) {
                    if (!(ctx.getAnnotatedElement() instanceof AccessibleObject)) {
                        ctx.getAnnotationBuilder().remove(Generic.class).add(InjectGenericLiteral.INSTANCE);
                        if (ctx.getRawType().isAnnotationPresent(GenericConfiguration.class)) {
                            ctx.getAnnotationBuilder().add(GenericBeanExtension.this.genericBeanQualifier);
                        }
                    }
                }
            });
            event.setAnnotatedType(builder.create());
        }
    }

    <X> void registerGenericBean(@Observes ProcessManagedBean<X> event) {
        AnnotatedType type = event.getAnnotatedBeanClass();
        if (type.isAnnotationPresent(GenericConfiguration.class)) {
            Class<? extends Annotation> genericType = ((GenericConfiguration)type.getAnnotation(GenericConfiguration.class)).value();
            this.genericBeans.put(genericType, new BeanHolder(event.getAnnotatedBeanClass(), event.getBean()));
            for (AnnotatedMethod m : event.getAnnotatedBeanClass().getMethods()) {
                if (!m.isAnnotationPresent(Unwraps.class)) continue;
                this.unwrapsMethods.put(genericType, m);
            }
        }
    }

    <X, T> void registerGenericBeanProducerMethod(@Observes ProcessProducerMethod<X, T> event) {
        AnnotatedType declaringType = event.getAnnotatedProducerMethod().getDeclaringType();
        Annotation genericConfiguration = GenericBeanExtension.getGenericConfiguration(event.getAnnotated());
        if (declaringType.isAnnotationPresent(GenericConfiguration.class)) {
            this.genericBeanProducerMethods.put(((GenericConfiguration)declaringType.getAnnotation(GenericConfiguration.class)).value(), GenericBeanExtension.getProducerMethodHolder(event));
        } else if (genericConfiguration != null && this.validateGenericProducer(genericConfiguration, (Bean<?>)event.getBean(), (AnnotatedMember<X>)event.getAnnotatedProducerMethod())) {
            this.genericProducerBeans.put((AnnotatedMember<?>)event.getAnnotatedProducerMethod(), (Bean<?>)event.getBean());
        }
    }

    private <X> boolean validateGenericProducer(Annotation genericConfiguration, Bean<?> bean, AnnotatedMember<X> member) {
        Class<?> configType = genericConfiguration.annotationType().getAnnotation(GenericType.class).value();
        boolean valid = false;
        for (Type type : bean.getTypes()) {
            Class clazz;
            if (!(type instanceof Class) || !configType.isAssignableFrom(clazz = (Class)type)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            AnnotatedType declaringType = member.getDeclaringType();
            this.errors.add("Generic producer method is not of correct type. Producer: " + declaringType.getJavaClass().getName() + "." + member.getJavaMember().getName() + ". Expected producer to be of type " + configType + " but was actually " + member.getBaseType());
        }
        return valid;
    }

    private static <X, T> ProducerMethodHolder<X, T> getProducerMethodHolder(ProcessProducerMethod<X, T> event) {
        if (event.getAnnotatedDisposedParameter() instanceof AnnotatedParameter) {
            return new ProducerMethodHolder(event.getAnnotatedProducerMethod(), (AnnotatedMethod)event.getAnnotatedDisposedParameter().getDeclaringCallable(), event.getBean());
        }
        return new ProducerMethodHolder(event.getAnnotatedProducerMethod(), null, event.getBean());
    }

    <T, X> void registerGenericBeanObserverMethod(@Observes ProcessObserverMethod<T, X> event) {
        AnnotatedType declaringType = event.getAnnotatedMethod().getDeclaringType();
        if (declaringType.isAnnotationPresent(GenericConfiguration.class)) {
            AnnotatedMethod method = event.getAnnotatedMethod();
            Class<? extends Annotation> genericConfigurationType = ((GenericConfiguration)declaringType.getAnnotation(GenericConfiguration.class)).value();
            this.genericBeanObserverMethods.put(genericConfigurationType, new ObserverMethodHolder(method, event.getObserverMethod()));
        }
    }

    <X, T> void registerGenericBeanProducerField(@Observes ProcessProducerField<X, T> event) {
        AnnotatedType declaringType = event.getAnnotatedProducerField().getDeclaringType();
        Annotation genericConfiguration = GenericBeanExtension.getGenericConfiguration(event.getAnnotated());
        if (declaringType.isAnnotationPresent(GenericConfiguration.class)) {
            AnnotatedField field = event.getAnnotatedProducerField();
            Class<? extends Annotation> genericConfigurationType = ((GenericConfiguration)declaringType.getAnnotation(GenericConfiguration.class)).value();
            this.genericBeanProducerFields.put(genericConfigurationType, new FieldHolder(field, event.getBean()));
        } else if (genericConfiguration != null && this.validateGenericProducer(genericConfiguration, (Bean<?>)event.getBean(), (AnnotatedMember<X>)event.getAnnotatedProducerField())) {
            this.genericProducerBeans.put((AnnotatedMember<?>)event.getAnnotatedProducerField(), (Bean<?>)event.getBean());
        }
    }

    <X> void registerGenericBeanInjectionTarget(@Observes ProcessInjectionTarget<X> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(GenericConfiguration.class)) {
            this.genericInjectionTargets.put(type, event.getInjectionTarget());
        }
    }

    <X> void processBean(@Observes ProcessBean<X> event, BeanManager manager) {
        Annotation genericConfiguration;
        if (!this.beanDiscoveryOver && (genericConfiguration = GenericBeanExtension.getGenericConfiguration(event.getAnnotated())) != null) {
            if (this.genericConfigurationPoints.containsKey(genericConfiguration)) {
                throw new IllegalStateException("Generic configuration " + genericConfiguration + " is defined twice [" + event.getAnnotated() + ", " + this.genericConfigurationPoints.get(genericConfiguration).getAnnotated() + "]");
            }
            Set qualifiers = event.getBean().getQualifiers();
            Iterator iterator = qualifiers.iterator();
            while (iterator.hasNext()) {
                Annotation qualifier = (Annotation)iterator.next();
                if (!qualifier.annotationType().equals(Synthetic.class)) continue;
                iterator.remove();
            }
            GenericIdentifier identifier = new GenericIdentifier(qualifiers, genericConfiguration);
            this.genericConfigurationPoints.put(identifier, new GenericConfigurationHolder(event.getAnnotated(), event.getBean().getBeanClass()));
        }
    }

    void createGenericBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        this.beanDiscoveryOver = true;
        for (Map.Entry<GenericIdentifier, GenericConfigurationHolder> genericConfigurationEntry : this.genericConfigurationPoints.entrySet()) {
            Class scopeOverride;
            Class producerScope = Dependent.class;
            for (Annotation annotation : genericConfigurationEntry.getValue().getAnnotated().getAnnotations()) {
                if (!beanManager.isScope(annotation.annotationType())) continue;
                producerScope = annotation.annotationType();
            }
            GenericConfigurationHolder genericConfigurationHolder = genericConfigurationEntry.getValue();
            GenericIdentifier identifier = genericConfigurationEntry.getKey();
            Class<? extends Annotation> genericConfigurationType = identifier.getAnnotationType();
            if (!this.genericBeans.containsKey(genericConfigurationType)) {
                throw new IllegalStateException("No generic bean definition exists for " + genericConfigurationType + ", but a generic producer does: " + genericConfigurationHolder.getAnnotated());
            }
            event.addBean(this.createGenericConfigurationBean(beanManager, identifier));
            event.addBean(this.createGenericProductAnnotatedMemberBean(beanManager, identifier));
            boolean alternative = genericConfigurationHolder.getAnnotated().isAnnotationPresent(Alternative.class);
            Class<?> javaClass = genericConfigurationHolder.getJavaClass();
            if (this.genericBeanProducerMethods.containsKey(genericConfigurationType)) {
                for (ProducerMethodHolder<?, ?> producerMethodHolder : this.genericBeanProducerMethods.get(genericConfigurationType)) {
                    scopeOverride = null;
                    if (producerMethodHolder.getProducerMethod().isAnnotationPresent(ApplyScope.class)) {
                        scopeOverride = producerScope;
                    }
                    event.addBean(this.createGenericProducerMethod(producerMethodHolder, identifier, beanManager, scopeOverride, alternative, javaClass));
                }
            }
            if (this.genericBeanProducerFields.containsKey(genericConfigurationType)) {
                for (FieldHolder fieldHolder : this.genericBeanProducerFields.get(genericConfigurationType)) {
                    scopeOverride = null;
                    if (fieldHolder.getField().isAnnotationPresent(ApplyScope.class)) {
                        scopeOverride = producerScope;
                    }
                    event.addBean(this.createGenericProducerField(fieldHolder.getBean(), identifier, fieldHolder.getField(), beanManager, scopeOverride, alternative, javaClass));
                }
            }
            if (this.genericBeanObserverMethods.containsKey(genericConfigurationType)) {
                for (ObserverMethodHolder observerMethodHolder : this.genericBeanObserverMethods.get(genericConfigurationType)) {
                    event.addObserverMethod(this.createGenericObserverMethod(observerMethodHolder.getObserverMethod(), identifier, observerMethodHolder.getMethod(), null, beanManager));
                }
            }
            if (this.unwrapsMethods.containsKey(genericConfigurationType)) {
                for (AnnotatedMethod annotatedMethod : this.unwrapsMethods.get(genericConfigurationType)) {
                    Annotated annotated = genericConfigurationHolder.getAnnotated();
                    Set<Annotation> unwrapsQualifiers = Beans.getQualifiers(beanManager, annotatedMethod.getAnnotations(), annotated.getAnnotations());
                    if (unwrapsQualifiers.isEmpty()) {
                        unwrapsQualifiers.add((Annotation)DefaultLiteral.INSTANCE);
                    }
                    Set<Annotation> beanQualifiers = Beans.getQualifiers(beanManager, annotatedMethod.getDeclaringType().getAnnotations(), annotated.getAnnotations());
                    beanQualifiers.remove(AnyLiteral.INSTANCE);
                    if (beanQualifiers.isEmpty()) {
                        beanQualifiers.add((Annotation)DefaultLiteral.INSTANCE);
                    }
                    beanQualifiers.remove(this.genericBeanQualifier);
                    event.addBean(new UnwrapsProducerBean(annotatedMethod, unwrapsQualifiers, beanQualifiers, beanManager));
                }
            }
            for (BeanHolder beanHolder : this.genericBeans.get(genericConfigurationType)) {
                scopeOverride = null;
                if (beanHolder.getType().isAnnotationPresent(ApplyScope.class)) {
                    scopeOverride = producerScope;
                }
                Bean genericBean = this.createGenericBean(beanHolder, identifier, beanManager, scopeOverride, alternative, javaClass);
                event.addBean(genericBean);
            }
        }
    }

    private static Annotation getGenericConfiguration(Annotated annotated) {
        Set<Annotation> genericConfigurationAnnotiations = AnnotationInspector.getAnnotations(annotated, GenericType.class);
        if (genericConfigurationAnnotiations.size() > 1) {
            throw new IllegalStateException("Can only have one generic configuration annotation on " + annotated);
        }
        if (genericConfigurationAnnotiations.size() == 1) {
            return genericConfigurationAnnotiations.iterator().next();
        }
        return null;
    }

    private Bean<?> createGenericConfigurationBean(BeanManager beanManager, final GenericIdentifier identifier) {
        Set<Annotation> qualifiers = this.getQualifiers(beanManager, identifier, identifier.getQualifiers());
        BeanBuilder<Annotation> builder = new BeanBuilder(beanManager).beanClass(identifier.getAnnotationType()).types(Arrays2.asSet(identifier.getAnnotationType(), Object.class)).scope(Dependent.class).qualifiers(qualifiers).beanLifecycle(new ContextualLifecycle<Annotation>(){

            @Override
            public void destroy(Bean<Annotation> bean, Annotation arg0, CreationalContext<Annotation> arg1) {
            }

            @Override
            public Annotation create(Bean<Annotation> bean, CreationalContext<Annotation> arg0) {
                return identifier.getConfiguration();
            }
        });
        return builder.create();
    }

    private Bean<Annotated> createGenericProductAnnotatedMemberBean(BeanManager beanManager, GenericIdentifier identifier) {
        final GenericConfigurationHolder holder = this.genericConfigurationPoints.get(identifier);
        BeanBuilder<Annotated> builder = new BeanBuilder(beanManager).beanClass(AnnotatedMember.class).qualifiers(Collections.singleton(this.annotatedMemberInjectionProvider.get(identifier))).beanLifecycle(new ContextualLifecycle<Annotated>(){

            @Override
            public void destroy(Bean<Annotated> bean, Annotated instance, CreationalContext<Annotated> ctx) {
            }

            @Override
            public Annotated create(Bean<Annotated> bean, CreationalContext<Annotated> ctx) {
                return holder.getAnnotated();
            }
        });
        return builder.create();
    }

    private <X> Bean<X> createGenericBean(BeanHolder<X> holder, GenericIdentifier identifier, BeanManager beanManager, Class<? extends Annotation> scopeOverride, boolean alternative, Class<?> beanClass) {
        Set<Annotation> qualifiers = this.getQualifiers(beanManager, identifier, Collections.<Annotation>emptySet());
        return new GenericManagedBean<X>(holder.getBean(), identifier, this.genericInjectionTargets.get(holder.getType()), holder.getType(), qualifiers, scopeOverride, this.annotatedMemberInjectionProvider, alternative, beanClass, beanManager);
    }

    private <X, T> Bean<T> createGenericProducerMethod(ProducerMethodHolder<X, T> holder, GenericIdentifier identifier, BeanManager beanManager, Class<? extends Annotation> scopeOverride, boolean alternative, Class<?> javaClass) {
        Set<Annotation> qualifiers = this.getQualifiers(beanManager, identifier, holder.getBean().getQualifiers());
        Set<Annotation> declaringBeanQualifiers = this.getQualifiers(beanManager, identifier, Collections.<Annotation>emptySet());
        return new GenericProducerMethod<T, X>(holder.getBean(), identifier, holder.getProducerMethod(), holder.getDisposerMethod(), qualifiers, declaringBeanQualifiers, scopeOverride, alternative, javaClass, beanManager);
    }

    public Set<Annotation> getQualifiers(BeanManager beanManager, GenericIdentifier identifier, Iterable<Annotation> annotations) {
        return Beans.getQualifiers(beanManager, this.genericConfigurationPoints.get(identifier).getAnnotated().getAnnotations(), annotations);
    }

    private <X, T> ObserverMethod<T> createGenericObserverMethod(ObserverMethod<T> originalObserverMethod, GenericIdentifier identifier, AnnotatedMethod<X> method, Bean<?> genericBean, BeanManager beanManager) {
        Set<Annotation> qualifiers = this.getQualifiers(beanManager, identifier, originalObserverMethod.getObservedQualifiers());
        Set<Annotation> declaringBeanQualifiers = this.getQualifiers(beanManager, identifier, Collections.<Annotation>emptySet());
        return new GenericObserverMethod<T, X>(originalObserverMethod, method, identifier.getConfiguration(), qualifiers, declaringBeanQualifiers, genericBean, beanManager);
    }

    private <X, T> Bean<T> createGenericProducerField(Bean<T> originalBean, GenericIdentifier identifier, AnnotatedField<X> field, BeanManager beanManager, Class<? extends Annotation> scopeOverride, boolean alternative, Class<?> javaClass) {
        Set<Annotation> declaringBeanQualifiers = this.getQualifiers(beanManager, identifier, originalBean.getQualifiers());
        Set<Annotation> qualifiers = this.getQualifiers(beanManager, identifier, field.getAnnotations());
        return new GenericProducerField<T, X>(originalBean, identifier, field, declaringBeanQualifiers, qualifiers, scopeOverride, alternative, javaClass, beanManager);
    }

    void cleanup(@Observes AfterDeploymentValidation event) {
        this.genericBeanObserverMethods.clear();
        this.genericBeanProducerFields.clear();
        this.genericBeanProducerMethods.clear();
        this.genericBeans.clear();
        this.genericConfigurationPoints.clear();
        this.genericInjectionTargets.clear();
        for (String s : this.errors) {
            event.addDeploymentProblem((Throwable)new Exception(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObserverMethodHolder<X, T> {
        private final AnnotatedMethod<X> method;
        private final ObserverMethod<T> observerMethod;

        private ObserverMethodHolder(AnnotatedMethod<X> method, ObserverMethod<T> observerMethod) {
            this.method = method;
            this.observerMethod = observerMethod;
        }

        public AnnotatedMethod<X> getMethod() {
            return this.method;
        }

        public ObserverMethod<T> getObserverMethod() {
            return this.observerMethod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldHolder<X, T> {
        private final AnnotatedField<X> field;
        private final Bean<T> bean;

        private FieldHolder(AnnotatedField<X> field, Bean<T> bean) {
            this.field = field;
            this.bean = bean;
        }

        public AnnotatedField<X> getField() {
            return this.field;
        }

        public Bean<T> getBean() {
            return this.bean;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericConfigurationHolder {
        private final Annotated annotated;
        private final Class<?> javaClass;

        public GenericConfigurationHolder(Annotated annotated, Class<?> javaClass) {
            this.annotated = annotated;
            this.javaClass = javaClass;
        }

        public Annotated getAnnotated() {
            return this.annotated;
        }

        public Class<?> getJavaClass() {
            return this.javaClass;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProducerMethodHolder<X, T> {
        private final AnnotatedMethod<X> producerMethod;
        private final AnnotatedMethod<X> disposerMethod;
        private final Bean<T> bean;

        private ProducerMethodHolder(AnnotatedMethod<X> producerMethod, AnnotatedMethod<X> disposerMethod, Bean<T> bean) {
            this.producerMethod = producerMethod;
            this.disposerMethod = disposerMethod;
            this.bean = bean;
        }

        public AnnotatedMethod<X> getProducerMethod() {
            return this.producerMethod;
        }

        public AnnotatedMethod<X> getDisposerMethod() {
            return this.disposerMethod;
        }

        public Bean<T> getBean() {
            return this.bean;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanHolder<T> {
        private final AnnotatedType<T> type;
        private final Bean<T> bean;

        private BeanHolder(AnnotatedType<T> type, Bean<T> bean) {
            this.type = type;
            this.bean = bean;
        }

        public AnnotatedType<T> getType() {
            return this.type;
        }

        public Bean<T> getBean() {
            return this.bean;
        }
    }
}

