/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.beanManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.solder.beanManager.BeanManagerProvider;
import org.jboss.seam.solder.beanManager.BeanManagerUnavailableException;
import org.jboss.seam.solder.util.Sortable;
import org.jboss.seam.solder.util.service.ServiceLoader;

public class BeanManagerLocator {
    private BeanManager beanManager;
    private boolean lookupPerformed = false;
    private BeanManagerProvider locatingProvider;
    private List<BeanManagerProvider> providers;

    public BeanManager getBeanManager() {
        if (!this.lookupPerformed) {
            this.beanManager = this.lookupBeanManager();
        }
        if (this.beanManager == null) {
            throw new BeanManagerUnavailableException(this.providers);
        }
        return this.beanManager;
    }

    public boolean isBeanManagerAvailable() {
        if (!this.lookupPerformed) {
            this.beanManager = this.lookupBeanManager();
        }
        return this.beanManager != null;
    }

    public BeanManagerProvider getLocatingProvider() {
        return this.locatingProvider;
    }

    private BeanManager lookupBeanManager() {
        BeanManager beanManager = null;
        if (this.providers == null) {
            this.loadServices();
            Collections.sort(this.providers, new Sortable.Comparator());
        }
        for (BeanManagerProvider provider : this.providers) {
            beanManager = provider.getBeanManager();
            if (beanManager == null) continue;
            this.locatingProvider = provider;
            break;
        }
        this.lookupPerformed = true;
        return beanManager;
    }

    private void loadServices() {
        this.providers = new ArrayList<BeanManagerProvider>();
        Iterator<BeanManagerProvider> it = ServiceLoader.load(BeanManagerProvider.class).iterator();
        while (it.hasNext()) {
            this.providers.add(it.next());
        }
    }
}

