/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.properties;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.security.AccessController;
import org.jboss.seam.solder.properties.FieldProperty;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.reflection.SetAccessiblePriviligedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldPropertyImpl<V>
implements FieldProperty<V> {
    private final Field field;

    FieldPropertyImpl(Field field) {
        this.field = field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Type getBaseType() {
        return this.field.getGenericType();
    }

    @Override
    public Field getAnnotatedElement() {
        return this.field;
    }

    @Override
    public Member getMember() {
        return this.field;
    }

    @Override
    public Class<V> getJavaClass() {
        return this.field.getType();
    }

    @Override
    public V getValue(Object instance) {
        return Reflections.getFieldValue(this.field, instance, this.getJavaClass());
    }

    @Override
    public void setValue(Object instance, V value) {
        Reflections.setFieldValue(this.field, instance, value);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setAccessible() {
        AccessController.doPrivileged(new SetAccessiblePriviligedAction(this.field));
    }

    public String toString() {
        return this.field.toString();
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object obj) {
        return this.field.equals(obj);
    }
}

