/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInspector {
    private AnnotationInspector() {
    }

    public static boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationType, boolean metaAnnotation, BeanManager beanManager) {
        return AnnotationInspector.getAnnotation(element, annotationType, metaAnnotation, beanManager) != null;
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationType, boolean metaAnnotation, BeanManager beanManager) {
        if (metaAnnotation) {
            for (Annotation annotation : element.getAnnotations()) {
                if (!beanManager.isStereotype(annotation.annotationType())) continue;
                for (Annotation stereotypedAnnotation : beanManager.getStereotypeDefinition(annotation.annotationType())) {
                    if (!stereotypedAnnotation.annotationType().equals(annotationType)) continue;
                    return (A)((Annotation)annotationType.cast(stereotypedAnnotation));
                }
            }
            return null;
        }
        return element.getAnnotation(annotationType);
    }

    public static <A extends Annotation> A getMetaAnnotation(Annotated element, Class<A> annotationType) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(annotationType)) continue;
            return annotation.annotationType().getAnnotation(annotationType);
        }
        return null;
    }

    public static Set<Annotation> getAnnotations(Annotated element, Class<? extends Annotation> metaAnnotationType) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
            annotations.add(annotation);
        }
        return annotations;
    }
}

