/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.reflection;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.seam.solder.reflection.AnnotationInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInstanceProvider {
    private final ConcurrentMap<Class<?>, Class<?>> cache = new ConcurrentHashMap();

    public <T extends Annotation> T get(Class<T> annotationType, Map<String, ?> values) {
        if (annotationType == null) {
            throw new IllegalArgumentException("Must specify an annotation");
        }
        Class<?> clazz = (Class<?>)this.cache.get(annotationType);
        if (clazz == null) {
            clazz = Proxy.getProxyClass(annotationType.getClassLoader(), annotationType, Serializable.class);
            this.cache.put(annotationType, clazz);
        }
        AnnotationInvocationHandler handler = new AnnotationInvocationHandler(values, annotationType);
        try {
            return (T)((Annotation)annotationType.cast(clazz.getConstructor(InvocationHandler.class).newInstance(handler)));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error instantiating proxy for annotation. Annotation type: " + annotationType, e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Error instantiating proxy for annotation. Annotation type: " + annotationType, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error instantiating proxy for annotation. Annotation type: " + annotationType, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Error instantiating proxy for annotation. Annotation type: " + annotationType, e.getCause());
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Error accessing proxy constructor for annotation. Annotation type: " + annotationType, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Error accessing proxy constructor for annotation. Annotation type: " + annotationType, e);
        }
    }
}

