/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.reflection;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.solder.reflection.SetAccessiblePriviligedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections {
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static Set<Field> getAllDeclaredFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Field a : c.getDeclaredFields()) {
                fields.add(a);
            }
        }
        return fields;
    }

    public static Field findDeclaredField(Class<?> clazz, String name) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static <X> AnnotatedField<? super X> getField(AnnotatedType<X> annotatedType, Field field) {
        for (AnnotatedField annotatedField : annotatedType.getFields()) {
            if (!annotatedField.getDeclaringType().getJavaClass().equals(field.getDeclaringClass()) || !annotatedField.getJavaMember().getName().equals(field.getName())) continue;
            return annotatedField;
        }
        return null;
    }

    public static Set<Annotation> getAnnotationsWithMetaAnnotation(Set<Annotation> annotations, Class<? extends Annotation> metaAnnotationType) {
        HashSet<Annotation> set = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
            set.add(annotation);
        }
        return set;
    }

    public static Set<Annotation> getQualifiers(Set<Annotation> annotations, BeanManager beanManager) {
        HashSet<Annotation> set = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (!beanManager.isQualifier(annotation.annotationType())) continue;
            set.add(annotation);
        }
        return set;
    }

    public static boolean methodExists(Class<?> clazz, String name) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                if (!m.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<Method> getAllDeclaredMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method a : c.getDeclaredMethods()) {
                methods.add(a);
            }
        }
        return methods;
    }

    public static Method findDeclaredMethod(Class<?> clazz, String name, Class<?> ... args) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredMethod(name, args);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Constructor<?> findDeclaredConstructor(Class<?> clazz, Class<?> ... args) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredConstructor(args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static Set<Constructor<?>> getAllDeclaredConstructors(Class<?> clazz) {
        HashSet constructors = new HashSet();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Constructor<?> constructor : c.getDeclaredConstructors()) {
                constructors.add(constructor);
            }
        }
        return constructors;
    }

    public static Class<?> getMemberType(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member instanceof Method) {
            return ((Method)member).getReturnType();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).getDeclaringClass();
        }
        throw new UnsupportedOperationException("Cannot operate on a member of type " + member.getClass());
    }

    public static Class<?> classForName(String name, ClassLoader ... loaders) throws ClassNotFoundException {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            for (ClassLoader l : loaders) {
                try {
                    return Class.forName(name, true, l);
                }
                catch (ClassNotFoundException ex) {
                }
            }
            if (Thread.currentThread().getContextClassLoader() != null) {
                throw new ClassNotFoundException("Could not load class " + name + " with the context class loader " + Thread.currentThread().getContextClassLoader().toString() + " or any of the additional ClassLoaders: " + Arrays.toString(loaders));
            }
            throw new ClassNotFoundException("Could not load class " + name + " using Class.forName or using any of the additional ClassLoaders: " + Arrays.toString(loaders));
        }
    }

    private static String buildInvokeMethodErrorMessage(Method method, Object obj, Object ... args) {
        StringBuilder message = new StringBuilder(String.format("Exception invoking method [%s] on object [%s], using arguments [", method.getName(), obj));
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                message.append((i > 0 ? "," : "") + args[i]);
            }
        }
        message.append("]");
        return message.toString();
    }

    public static <A extends AccessibleObject> A setAccessible(A member) {
        AccessController.doPrivileged(new SetAccessiblePriviligedAction(member));
        return member;
    }

    public static Object invokeMethod(Method method, Object instance, Object ... args) {
        return Reflections.invokeMethod(false, method, Object.class, instance, args);
    }

    public static Object invokeMethod(boolean setAccessible, Method method, Object instance, Object ... args) {
        return Reflections.invokeMethod(setAccessible, method, Object.class, instance, args);
    }

    public static <T> T invokeMethod(Method method, Class<T> expectedReturnType, Object instance, Object ... args) {
        return Reflections.invokeMethod(false, method, expectedReturnType, instance, args);
    }

    public static <T> T invokeMethod(boolean setAccessible, Method method, Class<T> expectedReturnType, Object instance, Object ... args) {
        if (setAccessible && !method.isAccessible()) {
            Reflections.setAccessible(method);
        }
        try {
            return expectedReturnType.cast(method.invoke(instance, args));
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex.getCause());
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildInvokeMethodErrorMessage(method, instance, args));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            ExceptionInInitializerError e2 = new ExceptionInInitializerError(Reflections.buildInvokeMethodErrorMessage(method, instance, args));
            e2.initCause(e.getCause());
            throw e2;
        }
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        Reflections.setFieldValue(false, field, instance, value);
    }

    public static void setFieldValue(boolean setAccessible, Field field, Object instance, Object value) {
        if (setAccessible && !field.isAccessible()) {
            Reflections.setAccessible(field);
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(Reflections.buildSetFieldValueErrorMessage(field, instance, value), e);
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildSetFieldValueErrorMessage(field, instance, value));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            ExceptionInInitializerError e2 = new ExceptionInInitializerError(Reflections.buildSetFieldValueErrorMessage(field, instance, value));
            e2.initCause(e.getCause());
            throw e2;
        }
    }

    private static String buildSetFieldValueErrorMessage(Field field, Object obj, Object value) {
        return String.format("Exception setting [%s] field on object [%s] to value [%s]", field.getName(), obj, value);
    }

    private static String buildGetFieldValueErrorMessage(Field field, Object obj) {
        return String.format("Exception reading [%s] field from object [%s].", field.getName(), obj);
    }

    public static Object getFieldValue(Field field, Object instance) {
        return Reflections.getFieldValue(field, instance, Object.class);
    }

    public static <T> T getFieldValue(Field field, Object instance, Class<T> expectedType) {
        try {
            return expectedType.cast(field.get(instance));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(Reflections.buildGetFieldValueErrorMessage(field, instance), e);
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildGetFieldValueErrorMessage(field, instance));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            ExceptionInInitializerError e2 = new ExceptionInInitializerError(Reflections.buildGetFieldValueErrorMessage(field, instance));
            e2.initCause(e.getCause());
            throw e2;
        }
    }

    public static <T> Class<T> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    private Reflections() {
    }
}

