/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.resourceLoader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.jboss.seam.solder.resourceLoader.ResourceLoader;
import org.jboss.seam.solder.util.Sortable;
import org.jboss.seam.solder.util.service.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoaderManager {
    private final List<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();

    public ResourceLoaderManager() {
        for (ResourceLoader resourceLoader : ServiceLoader.load(ResourceLoader.class)) {
            this.resourceLoaders.add(resourceLoader);
        }
        Collections.sort(this.resourceLoaders, new Sortable.Comparator());
    }

    public Iterable<ResourceLoader> getResourceLoaders() {
        return Collections.unmodifiableList(this.resourceLoaders);
    }

    public URL getResource(String name) {
        for (ResourceLoader loader : this.resourceLoaders) {
            URL url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Properties getPropertiesBundle(String name) {
        return this.loadProperties(this.getResourceAsStream(name), name);
    }

    private Properties loadProperties(InputStream is, String name) {
        Properties properties = new Properties();
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Error opening stream " + name, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing stream " + name, e);
                }
            }
        }
        return properties;
    }

    public Collection<Properties> getPropertiesBundles(String name) {
        HashSet<Properties> properties = new HashSet<Properties>();
        for (InputStream is : this.getResourcesAsStream(name)) {
            properties.add(this.loadProperties(is, name));
        }
        return properties;
    }

    public InputStream getResourceAsStream(String name) {
        for (ResourceLoader loader : this.resourceLoaders) {
            InputStream is = loader.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public Collection<URL> getResources(String name) {
        HashSet<URL> urls = new HashSet<URL>();
        for (ResourceLoader loader : this.resourceLoaders) {
            urls.addAll(loader.getResources(name));
        }
        return urls;
    }

    public Collection<InputStream> getResourcesAsStream(String name) {
        HashSet<InputStream> streams = new HashSet<InputStream>();
        for (ResourceLoader loader : this.resourceLoaders) {
            streams.addAll(loader.getResourcesAsStream(name));
        }
        return streams;
    }
}

