/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.logging.LogManager;
import org.jboss.logging.JDKLoggerProvider;
import org.jboss.logging.LoggerProvider;

final class LoggerProviders {
    static final LoggerProvider PROVIDER = LoggerProviders.findProvider();

    private static LoggerProvider findProvider() {
        LogManager jdkLogManager = LogManager.getLogManager();
        ClassLoader cl = LoggerProviders.getClassLoader();
        try {
            if (jdkLogManager.getClass().getName().equals("org.jboss.logmanager.LogManager")) {
                return (LoggerProvider)Class.forName("org.jboss.logging.JBossLogManagerProvider", true, cl).newInstance();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Class.forName("org.apache.log4j.LogManager", true, cl);
            return (LoggerProvider)Class.forName("org.jboss.logging.Log4jLoggerProvider", true, cl).newInstance();
        }
        catch (Throwable t) {
            try {
                Class.forName("ch.qos.logback.classic.Logger", false, cl);
                return (LoggerProvider)Class.forName("org.jboss.logging.Slf4jLoggerProvider", true, cl).newInstance();
            }
            catch (Throwable throwable) {
                return new JDKLoggerProvider();
            }
        }
    }

    private static ClassLoader getClassLoader() {
        return LoggerProviders.class.getClassLoader();
    }

    private LoggerProviders() {
    }
}

