/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.log;

import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.logging.Logger;
import org.jboss.seam.solder.log.Category;
import org.jboss.seam.solder.log.Locale;
import org.jboss.seam.solder.log.Suffix;
import org.jboss.seam.solder.log.TypedCategory;
import org.jboss.seam.solder.log.TypedLogger;
import org.jboss.seam.solder.log.TypedMessageBundle;
import org.jboss.seam.solder.logging.Messages;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.util.Locales;

class LoggerProducers {
    LoggerProducers() {
    }

    @Produces
    Logger produceLog(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated.isAnnotationPresent(Category.class)) {
            if (annotated.isAnnotationPresent(Suffix.class)) {
                return Logger.getLogger(((Category)annotated.getAnnotation(Category.class)).value(), ((Suffix)annotated.getAnnotation(Suffix.class)).value());
            }
            return Logger.getLogger(((Category)annotated.getAnnotation(Category.class)).value());
        }
        if (annotated.isAnnotationPresent(TypedCategory.class)) {
            if (annotated.isAnnotationPresent(Suffix.class)) {
                return Logger.getLogger(((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value(), ((Suffix)annotated.getAnnotation(Suffix.class)).value());
            }
            return Logger.getLogger(((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value());
        }
        if (annotated.isAnnotationPresent(Suffix.class)) {
            return Logger.getLogger(this.getDeclaringRawType(injectionPoint), ((Suffix)annotated.getAnnotation(Suffix.class)).value());
        }
        return Logger.getLogger(this.getDeclaringRawType(injectionPoint));
    }

    @Produces
    @TypedLogger
    Object produceTypedLogger(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated.isAnnotationPresent(Category.class)) {
            if (annotated.isAnnotationPresent(Locale.class)) {
                return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), ((Category)annotated.getAnnotation(Category.class)).value(), Locales.toLocale(((Locale)annotated.getAnnotation(Locale.class)).value()));
            }
            return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), ((Category)annotated.getAnnotation(Category.class)).value());
        }
        if (annotated.isAnnotationPresent(TypedCategory.class)) {
            if (annotated.isAnnotationPresent(Locale.class)) {
                return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), ((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value().getName(), Locales.toLocale(((Locale)annotated.getAnnotation(Locale.class)).value()));
            }
            return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), ((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value().getName());
        }
        throw new IllegalStateException("Must specify @Category or @TypedCategory for typed loggers at [" + injectionPoint + "]");
    }

    @Produces
    @TypedMessageBundle
    Object produceTypedMessageBundle(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated.isAnnotationPresent(Locale.class)) {
            return Messages.getBundle(Reflections.getRawType(injectionPoint.getType()), Locales.toLocale(((Locale)annotated.getAnnotation(Locale.class)).value()));
        }
        return Messages.getBundle(Reflections.getRawType(injectionPoint.getType()));
    }

    private Class<?> getInjectionPointRawType(InjectionPoint injectionPoint) {
        return Reflections.getRawType(injectionPoint.getType());
    }

    private Class<?> getDeclaringRawType(InjectionPoint injectionPoint) {
        if (injectionPoint.getBean() != null) {
            return Reflections.getRawType(injectionPoint.getBean().getBeanClass());
        }
        return Reflections.getRawType(injectionPoint.getMember().getDeclaringClass());
    }
}

