/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.logging;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.seam.solder.logging.LogMessage;
import org.jboss.seam.solder.logging.Message;
import org.jboss.seam.solder.logging.MessageBundleInvocationHandler;
import org.jboss.seam.solder.logging.MessageLogger;

public class MessageLoggerInvocationHandler
extends MessageBundleInvocationHandler {
    private final Logger logger;

    public MessageLoggerInvocationHandler(Class<?> type, String category) {
        this(type.getAnnotation(MessageLogger.class), category);
    }

    private MessageLoggerInvocationHandler(MessageLogger messageLogger, String category) {
        super(messageLogger.projectCode());
        this.logger = Logger.getLogger(category);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Message message = method.getAnnotation(Message.class);
        if (message == null) {
            return null;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        LogMessage logMessage = method.getAnnotation(LogMessage.class);
        if (logMessage != null) {
            try {
                if (method.getDeclaringClass().equals(BasicLogger.class)) {
                    return method.invoke((Object)this.logger, args);
                }
                Logger.Level level = logMessage.level();
                if (this.logger.isEnabled(level)) {
                    String formatString = this.getFormatString(message);
                    if (formatString == null) {
                        return null;
                    }
                    ArrayList<Object> newArgs = new ArrayList<Object>();
                    Throwable cause = MessageLoggerInvocationHandler.extractCause(parameterAnnotations, args, newArgs);
                    Message.Format format = message.format();
                    switch (format) {
                        case PRINTF: {
                            this.logger.logf(level, cause, formatString, newArgs.toArray());
                            return null;
                        }
                        case MESSAGE_FORMAT: {
                            this.logger.logv(level, cause, formatString, newArgs.toArray());
                            return null;
                        }
                    }
                    return null;
                }
            }
            catch (Throwable ignored) {}
        } else {
            return super.invoke(proxy, method, args);
        }
        return null;
    }
}

