/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;

public class AnnotationInspector {
    private AnnotationInspector() {
    }

    public static boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationType, BeanManager beanManager) {
        if (element.isAnnotationPresent(annotationType)) {
            return true;
        }
        return AnnotationInspector.isAnnotationPresentOnStereotype(Arrays.asList(element.getAnnotations()), annotationType, beanManager);
    }

    public static boolean isAnnotationPresent(Annotated annotated, Class<? extends Annotation> annotationType, BeanManager beanManager) {
        if (annotated.isAnnotationPresent(annotationType)) {
            return true;
        }
        return AnnotationInspector.isAnnotationPresentOnStereotype(annotated.getAnnotations(), annotationType, beanManager);
    }

    public static boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationType, boolean transitive, BeanManager beanManager) {
        if (transitive) {
            return AnnotationInspector.isAnnotationPresent(element, annotationType, beanManager);
        }
        return element.isAnnotationPresent(annotationType);
    }

    public static boolean isAnnotationPresentOnStereotype(AnnotatedElement element, Class<? extends Annotation> annotationType, BeanManager beanManager) {
        return AnnotationInspector.isAnnotationPresentOnStereotype(Arrays.asList(element.getAnnotations()), annotationType, beanManager);
    }

    public static boolean isAnnotationPresentOnStereotype(Annotated annotated, Class<? extends Annotation> annotationType, BeanManager beanManager) {
        return AnnotationInspector.isAnnotationPresentOnStereotype(annotated.getAnnotations(), annotationType, beanManager);
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationType, BeanManager beanManager) {
        if (element.isAnnotationPresent(annotationType)) {
            return (A)((Annotation)annotationType.cast(element.getAnnotation(annotationType)));
        }
        return AnnotationInspector.getAnnotationFromStereotype(Arrays.asList(element.getAnnotations()), annotationType, beanManager);
    }

    public static <A extends Annotation> A getAnnotation(Annotated annotated, Class<A> annotationType, BeanManager beanManager) {
        if (annotated.isAnnotationPresent(annotationType)) {
            return (A)((Annotation)annotationType.cast(annotated.getAnnotation(annotationType)));
        }
        return AnnotationInspector.getAnnotationFromStereotype(annotated.getAnnotations(), annotationType, beanManager);
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationType, boolean transitive, BeanManager beanManager) {
        if (transitive) {
            return AnnotationInspector.getAnnotation(element, annotationType, beanManager);
        }
        return element.getAnnotation(annotationType);
    }

    public static <A extends Annotation> A getAnnotationFromStereotype(AnnotatedElement element, Class<A> annotationType, BeanManager beanManager) {
        return AnnotationInspector.getAnnotationFromStereotype(Arrays.asList(element.getAnnotations()), annotationType, beanManager);
    }

    public static <A extends Annotation> A getAnnotationFromStereotype(Annotated annotated, Class<A> annotationType, BeanManager beanManager) {
        return AnnotationInspector.getAnnotationFromStereotype(annotated.getAnnotations(), annotationType, beanManager);
    }

    public static <A extends Annotation> A getMetaAnnotation(Annotated element, Class<A> annotationType) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(annotationType)) continue;
            return annotation.annotationType().getAnnotation(annotationType);
        }
        return null;
    }

    public static Set<Annotation> getAnnotations(Annotated element, Class<? extends Annotation> metaAnnotationType) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    private static boolean isAnnotationPresentOnStereotype(Collection<Annotation> annotations, Class<? extends Annotation> annotationType, BeanManager beanManager) {
        for (Annotation candidate : annotations) {
            if (!beanManager.isStereotype(candidate.annotationType())) continue;
            for (Annotation stereotyped : beanManager.getStereotypeDefinition(candidate.annotationType())) {
                if (!stereotyped.annotationType().equals(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    private static <A extends Annotation> A getAnnotationFromStereotype(Collection<Annotation> annotations, Class<A> annotationType, BeanManager beanManager) {
        for (Annotation candidate : annotations) {
            if (!beanManager.isStereotype(candidate.annotationType())) continue;
            for (Annotation stereotyped : beanManager.getStereotypeDefinition(candidate.annotationType())) {
                if (!stereotyped.annotationType().equals(annotationType)) continue;
                return (A)((Annotation)annotationType.cast(stereotyped));
            }
        }
        return null;
    }
}

