/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.reflection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class PrimitiveTypes {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPE;

    private PrimitiveTypes() {
    }

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static Set<Class<?>> allPrimitiveTypes() {
        return PRIMITIVE_TO_WRAPPER_TYPE.keySet();
    }

    public static Set<Class<?>> allWrapperTypes() {
        return WRAPPER_TO_PRIMITIVE_TYPE.keySet();
    }

    public static boolean isWrapperType(Class<?> type) {
        return WRAPPER_TO_PRIMITIVE_TYPE.containsKey(PrimitiveTypes.checkNotNull(type));
    }

    public static <T> Class<T> box(Class<T> type) {
        PrimitiveTypes.checkNotNull(type);
        Class<?> boxed = PRIMITIVE_TO_WRAPPER_TYPE.get(type);
        return boxed == null ? type : boxed;
    }

    public static <T> Class<T> unbox(Class<T> type) {
        PrimitiveTypes.checkNotNull(type);
        Class<?> unboxed = WRAPPER_TO_PRIMITIVE_TYPE.get(type);
        return unboxed == null ? type : unboxed;
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    static {
        HashMap primToWrap = new HashMap(16);
        HashMap wrapToPrim = new HashMap(16);
        PrimitiveTypes.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        PrimitiveTypes.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        PrimitiveTypes.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        PrimitiveTypes.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        PrimitiveTypes.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        PrimitiveTypes.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        PrimitiveTypes.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        PrimitiveTypes.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        PrimitiveTypes.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
        WRAPPER_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap(wrapToPrim);
    }
}

