/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.resourceLoader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.seam.solder.resourceLoader.Resource;
import org.jboss.seam.solder.resourceLoader.ResourceLoaderManager;

@ApplicationScoped
class ResourceProducer {
    @Inject
    private ResourceLoaderManager resourceLoaderManager;

    ResourceProducer() {
    }

    @Produces
    @Resource(value="")
    InputStream loadResourceStream(InjectionPoint injectionPoint) throws IOException {
        String name = this.getName(injectionPoint);
        return this.resourceLoaderManager.getResourceAsStream(name);
    }

    void closeResourceStream(@Disposes @Resource(value="") InputStream inputStream) throws IOException {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Produces
    @Resource(value="")
    Collection<InputStream> loadResourcesStream(InjectionPoint injectionPoint) throws IOException {
        String name = this.getName(injectionPoint);
        return this.resourceLoaderManager.getResourcesAsStream(name);
    }

    void closeResourcesStream(@Disposes @Resource(value="") Collection<InputStream> inputStreams) throws IOException {
        try {
            for (InputStream is : inputStreams) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Produces
    @Resource(value="")
    URL loadResource(InjectionPoint injectionPoint) {
        String name = this.getName(injectionPoint);
        return this.resourceLoaderManager.getResource(name);
    }

    @Produces
    @Resource(value="")
    Collection<URL> loadResources(InjectionPoint injectionPoint) {
        String name = this.getName(injectionPoint);
        return this.resourceLoaderManager.getResources(name);
    }

    @Produces
    @Resource(value="")
    Properties loadPropertiesBundle(InjectionPoint injectionPoint) {
        String name = this.getName(injectionPoint);
        return this.resourceLoaderManager.getPropertiesBundle(name);
    }

    @Produces
    @Resource(value="")
    Collection<Properties> loadPropertiesBundles(InjectionPoint injectionPoint) {
        String name = this.getName(injectionPoint);
        return this.resourceLoaderManager.getPropertiesBundles(name);
    }

    private String getName(InjectionPoint ip) {
        Set qualifiers = ip.getQualifiers();
        for (Annotation qualifier : qualifiers) {
            if (!qualifier.annotationType().equals(Resource.class)) continue;
            return ((Resource)qualifier).value();
        }
        throw new IllegalArgumentException("Injection point " + ip + " does not have @Resource qualifier");
    }
}

