/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.resourceLoader.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.seam.solder.resourceLoader.ResourceLoader;

class ServletContextLoader
implements ResourceLoader {
    private final ServletContext context;

    ServletContextLoader(ServletContext context) {
        this.context = context;
    }

    @Override
    public URL getResource(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        try {
            return this.context.getResource(resource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        return this.context.getResourceAsStream(resource);
    }

    public Set<URL> getResources(String name) {
        URL resource = this.getResource(name);
        if (resource != null) {
            return Collections.singleton(resource);
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<InputStream> getResourcesAsStream(String name) {
        InputStream resource = this.getResourceAsStream(name);
        if (resource != null) {
            return Collections.singleton(resource);
        }
        return Collections.emptySet();
    }

    @Override
    public int getPrecedence() {
        return 5;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.context.getContextPath() + "]";
    }
}

