/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.unwraps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import org.jboss.seam.solder.bean.Beans;
import org.jboss.seam.solder.literal.DefaultLiteral;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.unwraps.UnwrapsInvocationHandler;

public class UnwrapsProducerBean<M>
implements Bean<M> {
    private final Class<?> beanClass;
    private final String name;
    private final Set<Annotation> qualifiers;
    private final Set<Annotation> declaringClassQualifiers;
    private final Set<Type> types;
    private final Class<M> proxyClass;
    private final BeanManager manager;
    private final AnnotatedMethod<?> method;
    private static final Annotation[] defaultQualifiers = new Annotation[]{DefaultLiteral.INSTANCE};

    public UnwrapsProducerBean(AnnotatedMethod<?> method, BeanManager manager) {
        this(method, UnwrapsProducerBean.resolveQualifiers(method, manager), UnwrapsProducerBean.resolveQualifiers((Annotated)method.getDeclaringType(), manager), manager);
    }

    public UnwrapsProducerBean(AnnotatedMethod<?> method, Set<Annotation> methodQualifiers, Set<Annotation> beanQualifiers, BeanManager manager) {
        this.method = method;
        this.beanClass = method.getDeclaringType().getJavaClass();
        this.name = method.isAnnotationPresent(Named.class) ? ((Named)method.getAnnotation(Named.class)).value() : null;
        this.qualifiers = new HashSet<Annotation>(methodQualifiers);
        this.declaringClassQualifiers = new HashSet<Annotation>(beanQualifiers);
        this.types = new HashSet<Type>();
        HashSet<Class> classes = new HashSet<Class>();
        for (Type t : method.getTypeClosure()) {
            if (t instanceof Class) {
                Class c = (Class)t;
                this.types.add(c);
                classes.add(c);
                continue;
            }
            if (!(t instanceof ParameterizedType)) continue;
            this.types.add(t);
        }
        Class[] iarray = new Class[classes.size()];
        int count = 0;
        this.manager = manager;
        for (Class c : classes) {
            iarray[count++] = c;
        }
        ProxyFactory f = new ProxyFactory();
        Class<?> retType = method.getJavaMember().getReturnType();
        if (retType.isInterface()) {
            f.setSuperclass(Object.class);
            Class[] ifaces = new Class[]{retType};
            f.setInterfaces(ifaces);
        } else {
            f.setSuperclass(retType);
        }
        f.setFilter(new MethodFilter(){

            public boolean isHandled(Method m) {
                return !m.getName().equals("finalize");
            }
        });
        this.proxyClass = (Class)Reflections.cast(f.createClass());
    }

    private static Set<Annotation> resolveQualifiers(Annotated method, BeanManager manager) {
        Set<Annotation> qualifiers = Beans.getQualifiers(manager, (Iterable<Annotation>)method.getAnnotations());
        if (qualifiers.isEmpty()) {
            qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
        }
        return qualifiers;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return this.name;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public M create(CreationalContext<M> creationalContext) {
        Set beans = this.manager.getBeans(InjectionPoint.class, defaultQualifiers);
        Bean injectionPointBean = (Bean)beans.iterator().next();
        InjectionPoint injectionPoint = (InjectionPoint)this.manager.getReference(injectionPointBean, InjectionPoint.class, creationalContext);
        UnwrapsInvocationHandler hdl = new UnwrapsInvocationHandler(this.manager, this.method, this, injectionPoint, this.declaringClassQualifiers);
        try {
            M obj = this.proxyClass.newInstance();
            ((ProxyObject)obj).setHandler((MethodHandler)hdl);
            creationalContext.push(obj);
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy(M instance, CreationalContext<M> creationalContext) {
        creationalContext.release();
    }
}

