/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Seam Solder integrates JBoss Logging 3 as its logging framework of choice
 *
 * <p>JBoss Logging 3 is a modern logging framework offering:</p>
 *
 * <ul>
 *   <li>Abstraction over common logging back ends and frameworks (such as JDK Logging, log4j and slf4j)</li>
 *   <li>Innovative, typed-safe loggers</li>
 *   <li>Full support for internationalization and localization
 *      <ul>
 *         <li>Developers can work with interfaces and annotations only</li>
 *         <li>Translators can work with message bundles in properties files</li>
 *      </ul>
 *   </li>
 *   <li>Build time tooling to generate typed loggers for production, and runtime generation of typed loggers for development</li>
 *   <li>Access to MDC and NDC (if underlying logger supports it)</li>
 *   <li>Serializable loggers</li>
 * </ul>
 *
 * <p>Version imported: <a href="http://repository.jboss.org/nexus/content/groups/public/org/jboss/logging/jboss-logging/3.0.0.Beta4">jboss-logging-3.0.0.Beta4</a></p>
 */
package org.jboss.logging;
