/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.core;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.inject.Named;
import org.jboss.seam.solder.core.Exact;
import org.jboss.seam.solder.core.FullyQualified;
import org.jboss.seam.solder.core.Requires;
import org.jboss.seam.solder.core.VersionLoggerUtil;
import org.jboss.seam.solder.core.Veto;
import org.jboss.seam.solder.literal.NamedLiteral;
import org.jboss.seam.solder.logging.Logger;
import org.jboss.seam.solder.properties.Properties;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;

public class CoreExtension
implements Extension {
    private final Collection<Bean<?>> additionalBeans = new ArrayList();
    static final Logger log = Logger.getLogger(CoreExtension.class);

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd) {
        VersionLoggerUtil.logVersionInformation(this.getClass(), (String)"Seam Solder %s (build id: %s)", (String)"org.jboss.seam.solder.Version");
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        Class type;
        Package targetPackage;
        String name;
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        Package pkg = javaClass.getPackage();
        if (annotatedType.isAnnotationPresent(Veto.class) || pkg != null && pkg.isAnnotationPresent(Veto.class)) {
            pat.veto();
            log.info((Object)("Preventing " + javaClass + " from being installed as bean due to @Veto annotation"));
            return;
        }
        HashSet<String> requiredClasses = new HashSet<String>();
        if (pkg != null && pkg.isAnnotationPresent(Requires.class)) {
            String[] packageRequiredClasses = pkg.getAnnotation(Requires.class).value();
            requiredClasses.addAll(Arrays.asList(packageRequiredClasses));
        }
        if (annotatedType.isAnnotationPresent(Requires.class)) {
            String[] typeRequiredClasses = ((Requires)annotatedType.getAnnotation(Requires.class)).value();
            requiredClasses.addAll(Arrays.asList(typeRequiredClasses));
        }
        if (!requiredClasses.isEmpty()) {
            for (String i : requiredClasses) {
                try {
                    Reflections.classForName((String)i, (ClassLoader[])new ClassLoader[]{javaClass.getClassLoader()});
                }
                catch (ClassNotFoundException e) {
                    log.info((Object)("Preventing " + javaClass + " from being installed as required class " + i + " could not be found"));
                    pat.veto();
                }
                catch (LinkageError e) {
                    log.info((Object)("Preventing " + javaClass + " from being installed as a linkage error occurred loading required class " + i + ". The linkage error was " + e.toString()));
                    pat.veto();
                }
            }
        }
        AnnotatedTypeBuilder<X> builder = null;
        NamedLiteral namedFromPackage = null;
        if (pkg != null && pkg.isAnnotationPresent(Named.class) && !annotatedType.isAnnotationPresent(Named.class)) {
            builder = this.initializeBuilder(builder, annotatedType);
            namedFromPackage = new NamedLiteral();
            builder.addToClass((Annotation)namedFromPackage);
        }
        FullyQualified qualifiedOnPackage = null;
        if (pkg != null) {
            qualifiedOnPackage = pkg.getAnnotation(FullyQualified.class);
        }
        if ((namedFromPackage != null || annotatedType.isAnnotationPresent(Named.class)) && (qualifiedOnPackage != null || annotatedType.isAnnotationPresent(FullyQualified.class))) {
            String name2;
            builder = this.initializeBuilder(builder, annotatedType);
            String string = name2 = namedFromPackage != null ? namedFromPackage.value() : ((Named)annotatedType.getAnnotation(Named.class)).value();
            if (name2.length() == 0) {
                name2 = this.deriveBeanNameForType(javaClass);
            }
            Package targetPackage2 = this.resolveTargetPackage((FullyQualified)annotatedType.getAnnotation(FullyQualified.class), qualifiedOnPackage, pkg);
            builder.removeFromClass(Named.class);
            builder.addToClass((Annotation)new NamedLiteral(this.qualify(targetPackage2, name2)));
        }
        for (AnnotatedField f : annotatedType.getFields()) {
            if (f.isAnnotationPresent(Exact.class)) {
                Class type2 = ((Exact)f.getAnnotation(Exact.class)).value();
                builder = this.initializeBuilder(builder, annotatedType);
                builder.overrideFieldType(f, (Type)type2);
            }
            if (!f.isAnnotationPresent(Produces.class) || !f.isAnnotationPresent(Named.class) || qualifiedOnPackage == null && !f.isAnnotationPresent(FullyQualified.class)) continue;
            name = ((Named)f.getAnnotation(Named.class)).value();
            if (name.length() == 0) {
                name = f.getJavaMember().getName();
            }
            targetPackage = this.resolveTargetPackage((FullyQualified)f.getAnnotation(FullyQualified.class), qualifiedOnPackage, pkg);
            builder.removeFromField(f, Named.class);
            builder.addToField(f, (Annotation)new NamedLiteral(this.qualify(targetPackage, name)));
        }
        for (AnnotatedMethod m : annotatedType.getMethods()) {
            for (AnnotatedParameter p : m.getParameters()) {
                if (!p.isAnnotationPresent(Exact.class)) continue;
                type = ((Exact)p.getAnnotation(Exact.class)).value();
                builder = this.initializeBuilder(builder, annotatedType);
                builder.overrideParameterType(p, type);
            }
            if (!m.isAnnotationPresent(Produces.class) || !m.isAnnotationPresent(Named.class) || qualifiedOnPackage == null && !m.isAnnotationPresent(FullyQualified.class)) continue;
            name = ((Named)m.getAnnotation(Named.class)).value();
            if (name.length() == 0) {
                name = Properties.isProperty(m.getJavaMember()) ? Properties.createProperty(m.getJavaMember()).getName() : m.getJavaMember().getName();
            }
            targetPackage = this.resolveTargetPackage((FullyQualified)m.getAnnotation(FullyQualified.class), qualifiedOnPackage, pkg);
            builder.removeFromMethod(m, Named.class);
            builder.addToMethod(m, (Annotation)new NamedLiteral(this.qualify(targetPackage, name)));
        }
        for (AnnotatedConstructor c : annotatedType.getConstructors()) {
            for (AnnotatedParameter p : c.getParameters()) {
                if (!p.isAnnotationPresent(Exact.class)) continue;
                type = ((Exact)p.getAnnotation(Exact.class)).value();
                builder = this.initializeBuilder(builder, annotatedType);
                builder.overrideParameterType(p, type);
            }
        }
        if (builder != null) {
            pat.setAnnotatedType(builder.create());
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        this.failIfWeldExtensionsDetected(beanManager);
        for (Bean<?> bean : this.additionalBeans) {
            abd.addBean(bean);
        }
    }

    private void failIfWeldExtensionsDetected(BeanManager beanManager) {
        Iterator extensions = beanManager.getBeans(Extension.class, new Annotation[0]).iterator();
        while (extensions.hasNext()) {
            if (!((Bean)extensions.next()).getBeanClass().getName().equals("org.jboss.weld.extensions.core.CoreExtension")) continue;
            throw new IllegalStateException("Both Weld Extensions and Seam Solder libraries detected on the classpath. If you're migrating to Seam Solder, please remove Weld Extensions from the deployment.");
        }
    }

    private <X> AnnotatedTypeBuilder<X> initializeBuilder(AnnotatedTypeBuilder<X> currentBuilder, AnnotatedType<X> source) {
        if (currentBuilder == null) {
            return new AnnotatedTypeBuilder<X>().readFromType(source);
        }
        return currentBuilder;
    }

    private String qualify(Package pkg, String name) {
        return pkg.getName() + "." + name;
    }

    private Package resolveTargetPackage(FullyQualified qualifiedOnElement, FullyQualified qualifiedOnPackage, Package currentPackage) {
        FullyQualified qualified;
        FullyQualified fullyQualified = qualified = qualifiedOnElement != null ? qualifiedOnElement : qualifiedOnPackage;
        if (qualified.value() == Class.class) {
            return currentPackage;
        }
        return qualified.value().getPackage();
    }

    private String deriveBeanNameForType(Class<?> type) {
        return Introspector.decapitalize(type.getSimpleName());
    }
}

