/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.el;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.solder.beanManager.BeanManagerLocator;
import org.jboss.seam.solder.el.Composite;
import org.jboss.seam.solder.el.Resolver;
import org.jboss.seam.solder.literal.ResolverLiteral;

public class ELResolverProducer {
    @Produces
    @Composite
    public ELResolver getELResolver(@Resolver Instance<ELResolver> resolvers, BeanManager beanManager) {
        boolean isGlassFish;
        boolean bl = isGlassFish = System.getProperty("glassfish.version") != null;
        if (isGlassFish) {
            beanManager = new BeanManagerLocator().getBeanManager();
        }
        CompositeELResolver compositeResolver = new CompositeELResolver();
        compositeResolver.add(beanManager.getELResolver());
        compositeResolver.add((ELResolver)new MapELResolver());
        compositeResolver.add((ELResolver)new ListELResolver());
        compositeResolver.add((ELResolver)new ArrayELResolver());
        compositeResolver.add((ELResolver)new ResourceBundleELResolver());
        compositeResolver.add((ELResolver)new BeanELResolver());
        if (isGlassFish) {
            for (ELResolver resolver : this.getReferences(beanManager, ELResolver.class, new Annotation[]{new ResolverLiteral()})) {
                compositeResolver.add(resolver);
            }
        } else {
            for (ELResolver resolver : resolvers) {
                compositeResolver.add(resolver);
            }
        }
        return compositeResolver;
    }

    private <T> Set<T> getReferences(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        Set resolverBeans = manager.getBeans(type, qualifiers);
        if (resolverBeans.size() == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<Object> refs = new LinkedHashSet<Object>();
        for (Bean bean : resolverBeans) {
            CreationalContext context = manager.createCreationalContext((Contextual)bean);
            if (context == null) continue;
            refs.add(manager.getReference(bean, type, context));
        }
        return refs;
    }
}

