/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.serviceHandler;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.seam.solder.bean.BeanBuilder;
import org.jboss.seam.solder.logging.Logger;
import org.jboss.seam.solder.reflection.AnnotationInspector;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.serviceHandler.ServiceHandlerBeanLifecycle;
import org.jboss.seam.solder.serviceHandler.ServiceHandlerType;

public class ServiceHandlerExtension
implements Extension {
    private static final Logger log = Logger.getLogger(ServiceHandlerExtension.class);
    protected final Set<Bean<?>> beans = new HashSet();
    protected final boolean enabled;
    protected final Set<Throwable> problems = new HashSet<Throwable>();

    public ServiceHandlerExtension() {
        this.enabled = this.isEnabled();
    }

    protected boolean isEnabled() {
        try {
            Reflections.classForName((String)"javassist.util.proxy.MethodHandler", (ClassLoader[])new ClassLoader[]{ServiceHandlerExtension.class.getClassLoader()});
            return true;
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Javassist not preset, @ServiceHandler is disabled");
            return false;
        }
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event, BeanManager beanManager) {
        if (!this.enabled) {
            this.problems.add(new RuntimeException("Javassist not found on the class path, @ServiceHandler requires javassist to work. @ServiceHandler found on " + event.getAnnotatedType()));
        } else {
            Class<?> handlerClass = this.getHandlerClass(event);
            if (handlerClass != null) {
                this.buildBean(event.getAnnotatedType(), beanManager, handlerClass);
            }
        }
    }

    protected <X> Class<?> getHandlerClass(ProcessAnnotatedType<X> event) {
        ServiceHandlerType annotation = (ServiceHandlerType)AnnotationInspector.getMetaAnnotation((Annotated)event.getAnnotatedType(), ServiceHandlerType.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    protected <X> void buildBean(AnnotatedType<X> annotatedType, BeanManager beanManager, Class<?> handlerClass) {
        try {
            BeanBuilder<X> builder = new BeanBuilder<X>(beanManager);
            builder.readFromType(annotatedType);
            builder.beanLifecycle(new ServiceHandlerBeanLifecycle(annotatedType.getJavaClass(), handlerClass, beanManager));
            builder.toString("Generated @ServiceHandler for [" + builder.getBeanClass() + "] with qualifiers [" + builder.getQualifiers() + "] handled by " + handlerClass);
            this.beans.add(builder.create());
            log.debug((Object)("Adding @ServiceHandler bean for [" + builder.getBeanClass() + "] with qualifiers [" + builder.getQualifiers() + "] handled by " + handlerClass));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        for (Bean<?> bean : this.beans) {
            event.addBean(bean);
        }
        for (Throwable e : this.problems) {
            event.addDefinitionError(e);
        }
        this.beans.clear();
    }
}

