/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.logging;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.jboss.seam.logging.MessageLogger;
import org.jboss.seam.solder.bean.NarrowingBeanBuilder;
import org.jboss.seam.solder.logging.TypedMessageLogger;
import org.jboss.seam.solder.logging.TypedMessageLoggerProducer;

public class TypedMessageLoggerExtension
implements Extension {
    private final Collection<AnnotatedType<?>> messageLoggerTypes = new HashSet();
    private Bean<Object> loggerProducerBean;

    void detectInterfaces(@Observes ProcessAnnotatedType<?> event, BeanManager beanManager) {
        AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(MessageLogger.class)) {
            this.messageLoggerTypes.add(type);
        }
    }

    void detectProducers(@Observes ProcessProducerMethod<Object, TypedMessageLoggerProducer> event) {
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    @Deprecated
    void detectProducersInverted(@Observes ProcessProducerMethod<TypedMessageLoggerProducer, Object> event) {
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    void captureProducers(AnnotatedMethod<?> method, Bean<?> bean) {
        if (method.isAnnotationPresent(TypedMessageLogger.class)) {
            this.loggerProducerBean = bean;
        }
    }

    void installBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (AnnotatedType<?> type : this.messageLoggerTypes) {
            event.addBean(TypedMessageLoggerExtension.createMessageLoggerBean(this.loggerProducerBean, type, beanManager));
        }
    }

    private static <T> Bean<T> createMessageLoggerBean(Bean<Object> delegate, AnnotatedType<T> type, BeanManager beanManager) {
        return new NarrowingBeanBuilder<T>(delegate, beanManager).readFromType(type).types(new Type[]{type.getBaseType(), Object.class}).create();
    }

    void cleanup(@Observes AfterDeploymentValidation event) {
        this.messageLoggerTypes.clear();
    }
}

