/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.reflection;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;

@Retention(value=RetentionPolicy.RUNTIME)
@Qualifier
public @interface Synthetic {
    public long index();

    public String namespace();

    public static class Provider {
        private final Map<Object, Synthetic> synthetics = new HashMap<Object, Synthetic>();
        private final String namespace;
        private AtomicLong count;

        public Provider(String namespace) {
            this.namespace = namespace;
            this.count = new AtomicLong();
        }

        public Synthetic get(Object object) {
            if (!this.synthetics.containsKey(object)) {
                this.synthetics.put(object, new SyntheticLiteral(this.namespace, this.count.getAndIncrement()));
            }
            return this.synthetics.get(object);
        }

        public Synthetic get() {
            return new SyntheticLiteral(this.namespace, this.count.getAndIncrement());
        }

        public void clear() {
            this.synthetics.clear();
        }
    }

    public static class SyntheticLiteral
    extends AnnotationLiteral<Synthetic>
    implements Synthetic {
        private final Long index;
        private final String namespace;

        public SyntheticLiteral(String namespace, Long index) {
            this.namespace = namespace;
            this.index = index;
        }

        @Override
        public long index() {
            return this.index;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }
    }
}

