/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.serviceHandler;

import java.lang.reflect.Method;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;

class ServiceHandlerManager<T> {
    private final Class<T> handlerClass;
    private final Method handlerMethod;
    private final InjectionTarget<T> injectionTarget;

    ServiceHandlerManager(Class<T> handlerClass, BeanManager beanManager) throws IllegalArgumentException {
        this.handlerClass = handlerClass;
        this.handlerMethod = ServiceHandlerManager.getHandlerMethod(handlerClass);
        AnnotatedTypeBuilder typeBuilder = new AnnotatedTypeBuilder<T>().readFromType(handlerClass);
        this.injectionTarget = beanManager.createInjectionTarget(typeBuilder.create());
    }

    T create(CreationalContext<T> ctx) {
        Object instance = this.injectionTarget.produce(ctx);
        this.injectionTarget.inject(instance, ctx);
        this.injectionTarget.postConstruct(instance);
        return (T)instance;
    }

    Object invoke(Object instance, InvocationContext ctx) throws Exception {
        return this.handlerMethod.invoke(instance, ctx);
    }

    Class<?> getHandlerClass() {
        return this.handlerClass;
    }

    private static Method getHandlerMethod(Class<?> handlerClass) {
        for (Method m : Reflections.getAllDeclaredMethods(handlerClass)) {
            if (!m.isAnnotationPresent(AroundInvoke.class)) continue;
            if (m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != InvocationContext.class) {
                throw new IllegalArgumentException("Could not find suitable AroundInvoke method on class " + handlerClass + " methods denoted @AroundInvoke must have a single InvokationContext parameter");
            }
            return m;
        }
        throw new IllegalArgumentException("Could not find suitable AroundInvoke method on class " + handlerClass);
    }
}

