/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.util.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.jboss.seam.solder.util.collections.AbstractMultimap;
import org.jboss.seam.solder.util.collections.Preconditions;
import org.jboss.seam.solder.util.collections.WrappedIterator;

class WrappedCollection<K, V>
extends AbstractCollection<V> {
    private final AbstractMultimap<K, V> abstractMultimap;
    final K key;
    Collection<V> delegate;
    final WrappedCollection<K, V> ancestor;
    final Collection<V> ancestorDelegate;

    WrappedCollection(AbstractMultimap<K, V> abstractMultimap, K key, Collection<V> delegate, WrappedCollection<K, V> ancestor) {
        this.abstractMultimap = abstractMultimap;
        this.key = key;
        this.delegate = delegate;
        this.ancestor = ancestor;
        this.ancestorDelegate = ancestor == null ? null : ancestor.getDelegate();
    }

    public AbstractMultimap<K, V> getParent() {
        return this.abstractMultimap;
    }

    void refreshIfEmpty() {
        Collection newDelegate;
        if (this.ancestor != null) {
            this.ancestor.refreshIfEmpty();
            if (this.ancestor.getDelegate() != this.ancestorDelegate) {
                throw new ConcurrentModificationException();
            }
        } else if (this.delegate.isEmpty() && (newDelegate = this.abstractMultimap.map.get(this.key)) != null) {
            this.delegate = newDelegate;
        }
    }

    void removeIfEmpty() {
        if (this.ancestor != null) {
            this.ancestor.removeIfEmpty();
        } else if (this.delegate.isEmpty()) {
            this.abstractMultimap.map.remove(this.key);
        }
    }

    K getKey() {
        return this.key;
    }

    void addToMap() {
        if (this.ancestor != null) {
            this.ancestor.addToMap();
        } else {
            this.abstractMultimap.map.put(this.key, this.delegate);
        }
    }

    @Override
    public int size() {
        this.refreshIfEmpty();
        return this.delegate.size();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        this.refreshIfEmpty();
        return ((Object)this.delegate).equals(object);
    }

    @Override
    public int hashCode() {
        this.refreshIfEmpty();
        return ((Object)this.delegate).hashCode();
    }

    @Override
    public String toString() {
        this.refreshIfEmpty();
        return this.delegate.toString();
    }

    Collection<V> getDelegate() {
        return this.delegate;
    }

    @Override
    public Iterator<V> iterator() {
        this.refreshIfEmpty();
        return new WrappedIterator(this);
    }

    @Override
    public boolean add(V value) {
        this.refreshIfEmpty();
        boolean wasEmpty = this.delegate.isEmpty();
        boolean changed = this.delegate.add(value);
        if (changed) {
            ++this.abstractMultimap.totalSize;
            if (wasEmpty) {
                this.addToMap();
            }
        }
        return changed;
    }

    WrappedCollection<K, V> getAncestor() {
        return this.ancestor;
    }

    @Override
    public boolean addAll(Collection<? extends V> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        boolean changed = this.delegate.addAll(collection);
        if (changed) {
            int newSize = this.delegate.size();
            this.abstractMultimap.totalSize += newSize - oldSize;
            if (oldSize == 0) {
                this.addToMap();
            }
        }
        return changed;
    }

    @Override
    public boolean contains(Object o) {
        this.refreshIfEmpty();
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.refreshIfEmpty();
        return this.delegate.containsAll(c);
    }

    @Override
    public void clear() {
        int oldSize = this.size();
        if (oldSize == 0) {
            return;
        }
        this.delegate.clear();
        this.abstractMultimap.totalSize -= oldSize;
        this.removeIfEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.refreshIfEmpty();
        boolean changed = this.delegate.remove(o);
        if (changed) {
            --this.abstractMultimap.totalSize;
            this.removeIfEmpty();
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        boolean changed = this.delegate.removeAll(c);
        if (changed) {
            int newSize = this.delegate.size();
            this.abstractMultimap.totalSize += newSize - oldSize;
            this.removeIfEmpty();
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Preconditions.checkNotNull(c);
        int oldSize = this.size();
        boolean changed = this.delegate.retainAll(c);
        if (changed) {
            int newSize = this.delegate.size();
            this.abstractMultimap.totalSize += newSize - oldSize;
            this.removeIfEmpty();
        }
        return changed;
    }
}

