/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.jboss.solder.logging.Logger;

class SynchronizationRegistry {
    private static final Logger log = Logger.getLogger(SynchronizationRegistry.class);
    private final List<Synchronization> synchronizations = new ArrayList<Synchronization>();

    void registerSynchronization(Synchronization sync) {
        this.synchronizations.add(sync);
    }

    void afterTransactionCompletion(boolean success) {
        for (Synchronization sync : this.synchronizations) {
            try {
                sync.afterCompletion(success ? 3 : 4);
            }
            catch (Exception e) {
                log.error((Object)"Exception processing transaction Synchronization after completion", (Throwable)e);
            }
        }
        this.synchronizations.clear();
    }

    void beforeTransactionCompletion() {
        for (Synchronization sync : this.synchronizations) {
            try {
                sync.beforeCompletion();
            }
            catch (Exception e) {
                log.error((Object)"Exception processing transaction Synchronization before completion", (Throwable)e);
            }
        }
    }
}

