/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.mock;

import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.protocol.http.SecondLevelCacheSessionStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.tester.DummyHomePage;
import org.apache.wicket.util.tester.WicketTester;
import org.jboss.seam.wicket.SeamApplication;

public class SeamWicketTester
extends WicketTester {
    public SeamWicketTester() {
        super((WebApplication)new DummySeamApplication());
    }

    public SeamWicketTester(final Class<? extends Page> homePage) {
        super((WebApplication)new SeamApplication(){

            public Class<? extends Page> getHomePage() {
                return homePage;
            }

            protected ISessionStore newSessionStore() {
                return new HttpSessionStore((Application)this);
            }

            protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
                return new WebResponse(servletResponse);
            }

            protected void outputDevelopmentModeWarning() {
            }
        });
    }

    public static class NonPageCachingDummySeamApplication
    extends DummySeamApplication {
        @Override
        protected ISessionStore newSessionStore() {
            return new SecondLevelCacheSessionStore((Application)this, new SecondLevelCacheSessionStore.IPageStore(){

                public void destroy() {
                }

                public Page getPage(String sessionId, String pagemap, int id, int versionNumber, int ajaxVersionNumber) {
                    return null;
                }

                public void pageAccessed(String sessionId, Page page) {
                }

                public void removePage(String sessionId, String pagemap, int id) {
                }

                public void storePage(String sessionId, Page page) {
                }

                public void unbind(String sessionId) {
                }

                public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
                    return false;
                }
            });
        }
    }

    public static class DummySeamApplication
    extends SeamApplication {
        public Class<? extends Page> getHomePage() {
            return DummyHomePage.class;
        }

        protected ISessionStore newSessionStore() {
            return new HttpSessionStore((Application)this);
        }

        protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
            return new WebResponse(servletResponse);
        }

        protected void outputDevelopmentModeWarning() {
        }
    }
}

