/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.authorization;

//$Id: ResourceKeys.java 66879 2007-11-08 18:00:28Z anil.saldhana@jboss.com $

/**
 *  Defines the keys for the Context Map in the Resource
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jul 17, 2006 
 *  @version $Revision: 66879 $
 */
public interface ResourceKeys
{
   //Constants for the WEB Layer
   String WEB_CONTEXT = "web.context"; 
   String WEB_REQUEST = "web.request";
   String WEB_RESPONSE = "web.response";
   String WEB_SECURITY_CONSTRAINTS = "web.constraints"; 

   String HASROLE_PRINCIPAL = "hasRole.Principal";
   String PRINCIPAL_ROLES = "principal.roles";
   String SERVLET_NAME = "servletName";
   String RESOURCE_PERM_CHECK = "resourcePermissionCheck";
   String USERDATA_PERM_CHECK = "userDataPermissionCheck";
   
   //Constants for the EJB Layer
   String EJB_NAME = "ejb.name";
   String EJB_METHOD = "ejb.method";
   String EJB_PRINCIPAL = "ejb.principal";
   String EJB_METHODINTERFACE = "ejb.methodInterface";
   String EJB_CODESOURCE = "ejb.codeSource";  
   String EJB_METHODROLES = "ejb.methodRoles"; 
   
   //General Constants
   String CALLER_SUBJECT = "caller.subject";
   String AUTHORIZATION_MANAGER = "authorizationManager";
   String ROLENAME = "roleName";
   String ROLEREF_PERM_CHECK = "roleRefPermissionCheck";
   String RUNASIDENTITY = "runAsIdentity"; 
   String SECURITY_ROLE_REFERENCES = "securityRoleReferences";
   String SECURITY_CONTEXT_ROLES = "securityContextRoles";
}
