/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.idtrust.api.factories;

import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.idtrust.api.plugins.IDTrustSecurityManagement;

public class SecurityFactory {
    private static ISecurityManagement securityManagement = new IDTrustSecurityManagement();

    public static AuthenticationManager getAuthenticationManager(String securityDomain) {
        SecurityFactory.validate();
        return securityManagement.getAuthenticationManager(securityDomain);
    }

    public static AuthorizationManager getAuthorizationManager(String securityDomain) {
        SecurityFactory.validate();
        return securityManagement.getAuthorizationManager(securityDomain);
    }

    public static AuditManager getAuditManager(String securityDomain) {
        SecurityFactory.validate();
        return securityManagement.getAuditManager(securityDomain);
    }

    public static ISecurityManagement getSecurityManagement() {
        return securityManagement;
    }

    public static void setSecurityManagement(ISecurityManagement iSecurityManagement) {
        securityManagement = iSecurityManagement;
    }

    private static void validate() {
        assert (securityManagement != null);
    }
}

