/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.idtrust.api.plugins;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.idtrust.api.handlers.HandlerContract;

public class IDTrustCallbackHandler
implements CallbackHandler,
HandlerContract {
    private Principal principal = null;
    private Object credential = null;

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int len = callbacks.length;
        if (len > 0) {
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)cb;
                    nameCallback.setName(this.principal.getName());
                    continue;
                }
                if (cb instanceof ObjectCallback) {
                    ((ObjectCallback)cb).setCredential(this.credential);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    char[] passwd = null;
                    if (this.credential instanceof String) {
                        passwd = ((String)this.credential).toCharArray();
                    } else if (this.credential instanceof char[]) {
                        passwd = (char[])this.credential;
                    }
                    ((PasswordCallback)cb).setPassword(passwd);
                    continue;
                }
                throw new RuntimeException(this.getClass().getName() + " does not handle a callback of type " + cb.getClass().getCanonicalName());
            }
        }
    }

    public void setSecurityInfo(Principal principal, Object credential) {
        this.principal = principal;
        this.credential = credential;
    }
}

