/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.config;

import java.io.InputStream;
import java.util.List;

import javax.security.auth.login.Configuration;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.config.jaxb.ApplicationPolicy;
import org.jboss.security.config.jaxb.PolicyConfig; 

/**
 * IDTrust Configuration
 * <a href="mailto:anil.saldhana@redhat.com>Anil Saldhana</a>
 */
public class IDTrustConfiguration
{ 
   private static XMLLoginConfigImpl xmlConfig = XMLLoginConfigImpl.getInstance();
   private JBossSXConfigBridge bridge = new JBossSXConfigBridge();
   
   public IDTrustConfiguration()
   {
      Configuration config = null;
      try
      {
         config = Configuration.getConfiguration();  
      }
      catch(Exception ignore) {}
     if(config == null || !(config instanceof XMLLoginConfigImpl))
        Configuration.setConfiguration(xmlConfig);
   }
   
   @SuppressWarnings("unchecked")
   public void config(String configFile) throws Exception
   {
      ClassLoader tcl = Thread.currentThread().getContextClassLoader();
      InputStream is = tcl.getResourceAsStream(configFile);
      JAXBContext jaxbContext = JAXBContext.newInstance("org.jboss.security.config.jaxb");
      Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
      JAXBElement<PolicyConfig> jaxbElement = (JAXBElement<PolicyConfig>) unmarshaller.unmarshal(is);
      PolicyConfig policyConfig = jaxbElement.getValue(); 
      if(policyConfig == null)
         throw new IllegalStateException("policy Config is null");
      this.addApplicationPolicies(policyConfig.getApplicationPolicy());
   }
   
   public void addApplicationPolicies(List<ApplicationPolicy> appPoliciesList)
   { 
      for(ApplicationPolicy aPolicy: appPoliciesList)
      {
         xmlConfig.addApplicationPolicy(aPolicy.getName(), 
               bridge.map(aPolicy)); 
      } 
   } 
}