/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.io.InputStream;
import java.util.List;
import javax.security.auth.login.Configuration;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.config.JBossSXConfigBridge;
import org.jboss.security.config.jaxb.ApplicationPolicy;
import org.jboss.security.config.jaxb.PolicyConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDTrustConfiguration {
    private static XMLLoginConfigImpl xmlConfig = XMLLoginConfigImpl.getInstance();
    private JBossSXConfigBridge bridge = new JBossSXConfigBridge();

    public IDTrustConfiguration() {
        Configuration config = null;
        try {
            config = Configuration.getConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (config == null || !(config instanceof XMLLoginConfigImpl)) {
            Configuration.setConfiguration((Configuration)xmlConfig);
        }
    }

    public void config(String configFile) throws Exception {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        InputStream is = tcl.getResourceAsStream(configFile);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.jboss.security.config.jaxb");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement jaxbElement = (JAXBElement)unmarshaller.unmarshal(is);
        PolicyConfig policyConfig = (PolicyConfig)jaxbElement.getValue();
        if (policyConfig == null) {
            throw new IllegalStateException("policy Config is null");
        }
        this.addApplicationPolicies(policyConfig.getApplicationPolicy());
    }

    public void addApplicationPolicies(List<ApplicationPolicy> appPoliciesList) {
        for (ApplicationPolicy aPolicy : appPoliciesList) {
            xmlConfig.addApplicationPolicy(aPolicy.getName(), this.bridge.map(aPolicy));
        }
    }
}

