/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.jaxb.AuthenticationInfo;
import org.jboss.security.config.jaxb.AuthorizationInfo;
import org.jboss.security.config.jaxb.LoginModuleInfo;
import org.jboss.security.config.jaxb.ModuleOption;
import org.jboss.security.config.jaxb.ModuleOptionFlag;
import org.jboss.security.config.jaxb.PolicyModule;
import org.jboss.security.config.jaxb.ProviderModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSXConfigBridge {
    public ApplicationPolicy map(org.jboss.security.config.jaxb.ApplicationPolicy appPolicy) {
        String appName = appPolicy.getName();
        ApplicationPolicy result = new ApplicationPolicy(appName);
        result.setAuthenticationInfo(this.map(appName, appPolicy.getAuthentication()));
        result.setAuthorizationInfo(this.map(appName, appPolicy.getAuthorization()));
        result.setAuditInfo(this.map(appName, appPolicy.getAudit()));
        return result;
    }

    public BaseAuthenticationInfo map(String name, AuthenticationInfo authenticationInfo) {
        org.jboss.security.auth.login.AuthenticationInfo baseInfo = new org.jboss.security.auth.login.AuthenticationInfo(name);
        baseInfo.setAppConfigurationEntry(this.map(authenticationInfo.getLoginModule()));
        return baseInfo;
    }

    public org.jboss.security.config.AuthorizationInfo map(String name, AuthorizationInfo authorizationInfo) {
        int lenOfPolicyModules;
        if (authorizationInfo == null) {
            return null;
        }
        org.jboss.security.config.AuthorizationInfo authzInfo = new org.jboss.security.config.AuthorizationInfo(name);
        List<PolicyModule> policyModuleList = authorizationInfo.getPolicyModule();
        int n = lenOfPolicyModules = policyModuleList != null ? policyModuleList.size() : 0;
        if (lenOfPolicyModules > 0) {
            for (PolicyModule policyModule : policyModuleList) {
                AuthorizationModuleEntry authzEntry = new AuthorizationModuleEntry(policyModule.getCode());
                authzInfo.add((Object)authzEntry);
                authzEntry.setControlFlag(this.getControlFlag(policyModule.getFlag()));
                authzEntry.getOptions().putAll(this.map(policyModule.getModuleOption()));
            }
        }
        return authzInfo;
    }

    public AuditInfo map(String name, org.jboss.security.config.jaxb.AuditInfo auditInfo) {
        if (auditInfo == null) {
            return null;
        }
        AuditInfo audInfo = new AuditInfo(name);
        audInfo.add(this.map(auditInfo.getProviderModule()));
        return audInfo;
    }

    public AppConfigurationEntry[] map(List<LoginModuleInfo> loginModuleInfoList) {
        int index = 0;
        AppConfigurationEntry[] entries = new AppConfigurationEntry[loginModuleInfoList.size()];
        for (LoginModuleInfo loginModuleInfo : loginModuleInfoList) {
            entries[index++] = this.map(loginModuleInfo);
        }
        return entries;
    }

    public AppConfigurationEntry map(LoginModuleInfo loginModuleInfo) {
        String moduleName = loginModuleInfo.getCode();
        ModuleOptionFlag flag = loginModuleInfo.getFlag();
        List<ModuleOption> moduleOptionList = loginModuleInfo.getModuleOption();
        return new AppConfigurationEntry(moduleName, this.map(flag), this.map(moduleOptionList));
    }

    public Map<String, Object> map(List<ModuleOption> moduleOptionList) {
        if (moduleOptionList == null) {
            return null;
        }
        HashMap<String, Object> moduleOptions = new HashMap<String, Object>();
        for (ModuleOption moduleOption : moduleOptionList) {
            String name = moduleOption.getName();
            List<Object> objectList = moduleOption.getContent();
            moduleOptions.put(name, objectList.get(0));
        }
        return moduleOptions;
    }

    public List<AuditProviderEntry> map(List<ProviderModule> providerModulesList) {
        int len;
        ArrayList<AuditProviderEntry> auditProviderEntries = new ArrayList<AuditProviderEntry>();
        int n = len = providerModulesList != null ? providerModulesList.size() : 0;
        if (len > 0) {
            for (ProviderModule providerModule : providerModulesList) {
                AuditProviderEntry ape = new AuditProviderEntry(providerModule.getCode());
                ape.getOptions().putAll(this.map(providerModule.getModuleOption()));
                auditProviderEntries.add(ape);
            }
        }
        return auditProviderEntries;
    }

    public AppConfigurationEntry.LoginModuleControlFlag map(ModuleOptionFlag flag) {
        if (flag != null) {
            if (flag.compareTo(ModuleOptionFlag.OPTIONAL) == 0) {
                return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
            if (flag.compareTo(ModuleOptionFlag.SUFFICIENT) == 0) {
                return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            }
            if (flag.compareTo(ModuleOptionFlag.REQUISITE) == 0) {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
        }
        return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    }

    public ControlFlag getControlFlag(ModuleOptionFlag flag) {
        if (flag != null) {
            if (flag.compareTo(ModuleOptionFlag.OPTIONAL) == 0) {
                return ControlFlag.OPTIONAL;
            }
            if (flag.compareTo(ModuleOptionFlag.SUFFICIENT) == 0) {
                return ControlFlag.SUFFICIENT;
            }
            if (flag.compareTo(ModuleOptionFlag.REQUISITE) == 0) {
                return ControlFlag.REQUISITE;
            }
        }
        return ControlFlag.REQUIRED;
    }
}

