/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.jboss.security.negotiation.DelegationCredentialContext;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.common.MessageTrace;
import org.jboss.security.negotiation.common.NegotiationContext;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.util.Base64;

public class NegotiationAuthenticator
extends FormAuthenticator {
    public static final String BASIC_KEY = NegotiationAuthenticator.class.getName() + ".BasicAuthFallBack";
    private static final Logger log = Logger.getLogger(NegotiationAuthenticator.class);
    private static final String NEGOTIATE = "Negotiate";
    private static final String BASIC = "Basic";
    private static final String NEGOTIATION_CONTEXT = "NEGOTIATION_CONTEXT";
    private static final String DELEGATION_CREDENTIAL = "DELEGATION_CREDENTIAL";
    private static final String FORM_METHOD = "FORM";

    protected String getNegotiateScheme() {
        return NEGOTIATE;
    }

    protected String getBasicScheme() {
        return BASIC;
    }

    public boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        String username;
        String authHeader;
        boolean loginAction;
        boolean DEBUG = log.isDebugEnabled();
        log.trace((Object)"Authenticating user");
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            return true;
        }
        String contextPath = request.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        boolean bl = loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        if (loginAction) {
            String password;
            String username2;
            Realm realm = this.context.getRealm();
            principal = realm.authenticate(username2 = request.getParameter("j_username"), password = request.getParameter("j_password"));
            if (principal == null) {
                RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(config.getErrorPage());
                try {
                    disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
                }
                catch (ServletException e) {
                    IOException ex = new IOException("Unable to forward to error page.");
                    ex.initCause(e);
                    throw ex;
                }
                return false;
            }
            Session session = request.getSessionInternal();
            requestURI = this.savedRequestURL(session);
            session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
            session.setNote("org.apache.catalina.session.USERNAME", (Object)username2);
            session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            this.register(request, response, principal, FORM_METHOD, username2, password);
            response.sendRedirect(response.encodeRedirectURL(requestURI));
            return false;
        }
        String negotiateScheme = this.getNegotiateScheme();
        if (DEBUG) {
            log.debug((Object)("Header - " + request.getHeader("Authorization")));
        }
        if ((authHeader = request.getHeader("Authorization")) == null) {
            log.debug((Object)"No Authorization Header, initiating negotiation");
            this.initiateNegotiation(request, (HttpServletResponse)response, config);
            return false;
        }
        if (!authHeader.startsWith(negotiateScheme + " ")) {
            String basicScheme = this.getBasicScheme();
            if (authHeader.startsWith(basicScheme + " ")) {
                MessageBytes messagebytes = request.getCoyoteRequest().getMimeHeaders().getValue("Authorization");
                messagebytes.toBytes();
                ByteChunk byteChunk = messagebytes.getByteChunk();
                boolean successfulAuthenticated = false;
                if (byteChunk.startsWithIgnoreCase(basicScheme + " ", 0)) {
                    int offsetLength = basicScheme.length() + 1;
                    byteChunk.setOffset(byteChunk.getOffset() + offsetLength);
                    CharChunk charChunk = messagebytes.getCharChunk();
                    org.apache.catalina.util.Base64.decode((ByteChunk)byteChunk, (CharChunk)charChunk);
                    successfulAuthenticated = this.handleBasic(request, response, charChunk);
                    byteChunk.setOffset(byteChunk.getOffset() - offsetLength);
                    return successfulAuthenticated;
                }
            }
            throw new IOException("Invalid 'Authorization' header.");
        }
        String authTokenBase64 = authHeader.substring(negotiateScheme.length() + 1);
        byte[] authToken = Base64.decode((String)authTokenBase64);
        ByteArrayInputStream authTokenIS = new ByteArrayInputStream(authToken);
        MessageTrace.logRequestBase64(authTokenBase64);
        MessageTrace.logRequestHex(authToken);
        Session session = request.getSessionInternal();
        NegotiationContext negotiationContext = (NegotiationContext)session.getNote(NEGOTIATION_CONTEXT);
        if (negotiationContext == null) {
            log.debug((Object)"Creating new NegotiationContext");
            negotiationContext = new NegotiationContext();
            session.setNote(NEGOTIATION_CONTEXT, (Object)negotiationContext);
        }
        if ((username = negotiationContext.getUsername()) == null || username.length() == 0) {
            username = session.getId() + "_" + String.valueOf(System.currentTimeMillis());
            negotiationContext.setUsername(username);
        }
        String authenticationMethod = "";
        try {
            NegotiationMessage responseMessage;
            negotiationContext.associate();
            MessageFactory mf = MessageFactory.newInstance();
            if (!mf.accepts(authTokenIS)) {
                if (this.basicSupported()) {
                    this.initiateBasic(request, (HttpServletResponse)response, config);
                    response.sendError(401);
                    response.flushBuffer();
                    boolean bl2 = false;
                    return bl2;
                }
                throw new IOException("Unsupported negotiation mechanism.");
            }
            NegotiationMessage requestMessage = mf.createMessage(authTokenIS);
            if ("NTLM".equals(requestMessage.getMessageType()) && this.basicSupported()) {
                this.initiateBasic(request, (HttpServletResponse)response, config);
                response.sendError(401);
                response.flushBuffer();
                boolean bl3 = false;
                return bl3;
            }
            negotiationContext.setRequestMessage(requestMessage);
            Realm realm = this.context.getRealm();
            principal = realm.authenticate(username, (String)null);
            authenticationMethod = negotiationContext.getAuthenticationMethod();
            if (DEBUG && principal != null) {
                log.debug((Object)("authenticated principal = " + principal));
            }
            if ((responseMessage = negotiationContext.getResponseMessage()) != null) {
                ByteArrayOutputStream responseMessageOS = new ByteArrayOutputStream();
                responseMessage.writeTo(responseMessageOS, true);
                String responseHeader = responseMessageOS.toString();
                MessageTrace.logResponseBase64(responseHeader);
                response.setHeader("WWW-Authenticate", negotiateScheme + " " + responseHeader);
            }
        }
        catch (NegotiationException e) {
            IOException ioe = new IOException("Error processing " + negotiateScheme + " header.");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            negotiationContext.clear();
        }
        if (principal == null) {
            response.sendError(401);
        } else {
            GSSContext gssContext;
            Object schemeContext = negotiationContext.getSchemeContext();
            if (schemeContext instanceof GSSContext && (gssContext = (GSSContext)schemeContext).getCredDelegState()) {
                try {
                    GSSCredential delegCredential = gssContext.getDelegCred();
                    session.setNote(DELEGATION_CREDENTIAL, (Object)delegCredential);
                }
                catch (GSSException e) {
                    log.warn((Object)"Unable to obtain delegation credential.", (Throwable)e);
                }
            }
            this.register(request, response, principal, authenticationMethod, username, null);
        }
        return principal != null;
    }

    private boolean basicSupported() {
        return Boolean.parseBoolean(this.context.findParameter(BASIC_KEY));
    }

    private void initiateBasic(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        StringBuilder basicHeader = new StringBuilder();
        basicHeader.append(this.getBasicScheme());
        basicHeader.append(" realm=\"");
        if (config.getRealmName() == null) {
            basicHeader.append(request.getServerName());
            basicHeader.append(':');
            basicHeader.append(Integer.toString(request.getServerPort()));
        } else {
            basicHeader.append(config.getRealmName().toUpperCase());
        }
        basicHeader.append("\"");
        response.addHeader("WWW-Authenticate", basicHeader.toString());
    }

    protected boolean handleBasic(Request request, Response response, CharChunk charchunk) {
        String username = null;
        String password = null;
        int i = charchunk.indexOf(':');
        if (i < 0) {
            username = charchunk.toString();
        } else {
            char[] ac = charchunk.getBuffer();
            username = new String(ac, 0, i);
            password = new String(ac, i + 1, charchunk.getEnd() - i - 1);
        }
        try {
            Realm realm = this.context.getRealm();
            Principal principal = realm.authenticate(username, password);
            if (principal == null) {
                response.sendError(401);
                return false;
            }
            this.register(request, response, principal, this.getBasicScheme(), username, password);
            return true;
        }
        catch (Exception e) {
            log.info((Object)"Could not verify password - wrong password given or maybe LoginModule is misconfigured!", (Throwable)e);
            return false;
        }
    }

    private void initiateNegotiation(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        String loginPage = config.getLoginPage();
        if (loginPage != null) {
            ServletContext servletContext = this.context.getServletContext();
            RequestDispatcher disp = servletContext.getRequestDispatcher(loginPage);
            try {
                Session session = request.getSessionInternal();
                this.saveRequest(request, session);
                disp.include((ServletRequest)request.getRequest(), (ServletResponse)response);
                response.setHeader("WWW-Authenticate", this.getNegotiateScheme());
                response.setStatus(401);
            }
            catch (ServletException e) {
                IOException ex = new IOException("Unable to include loginPage");
                ex.initCause(e);
                throw ex;
            }
        } else {
            response.setHeader("WWW-Authenticate", this.getNegotiateScheme());
            if (this.basicSupported()) {
                this.initiateBasic(request, response, config);
            }
            response.sendError(401);
        }
        response.flushBuffer();
    }

    public void setNext(final Valve nextValve) {
        super.setNext(new Valve(){

            public String getInfo() {
                return nextValve.getInfo();
            }

            public Valve getNext() {
                return nextValve.getNext();
            }

            public void setNext(Valve valve) {
                nextValve.setNext(valve);
            }

            public void backgroundProcess() {
                nextValve.backgroundProcess();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(Request request, Response response) throws IOException, ServletException {
                Session session = request.getSessionInternal();
                GSSCredential credential = (GSSCredential)session.getNote(NegotiationAuthenticator.DELEGATION_CREDENTIAL);
                try {
                    DelegationCredentialManager.setDelegationCredential(credential);
                    nextValve.invoke(request, response);
                }
                finally {
                    DelegationCredentialManager.removeDelegationCredential();
                }
            }

            public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
                nextValve.event(request, response, event);
            }
        });
    }

    private static class DelegationCredentialManager
    extends DelegationCredentialContext {
        private DelegationCredentialManager() {
        }

        private static void setDelegationCredential(GSSCredential credential) {
            currentCredential.set(credential);
        }

        private static void removeDelegationCredential() {
            currentCredential.remove();
        }
    }
}

