/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.cipher;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.cipher.Decoder;

public class ArcFourHmacDecoder
extends Decoder {
    private static final int hashSize = 16;

    public int blockSize() {
        return 1;
    }

    public int checksumSize() {
        return 16;
    }

    public int confounderSize() {
        return 8;
    }

    public int keySize() {
        return 16;
    }

    public byte[] decrypt(byte[] cipher, byte[] key, int usage) throws NegotiationException {
        byte[] ivec = new byte[this.blockSize()];
        return this.decrypt(cipher, key, ivec, usage);
    }

    public byte[] decrypt(byte[] cipher, byte[] key, byte[] ivec, int usage) throws NegotiationException {
        try {
            return this.decrypt(key, usage, ivec, cipher, 0, cipher.length);
        }
        catch (GeneralSecurityException e) {
            NegotiationException ne = new NegotiationException(e.getMessage());
            ne.initCause(e);
            throw ne;
        }
    }

    private byte[] decrypt(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len) throws GeneralSecurityException {
        byte[] k1 = new byte[baseKey.length];
        System.arraycopy(baseKey, 0, k1, 0, baseKey.length);
        byte[] salt = this.getSalt(usage);
        byte[] k2 = this.getHmac(k1, salt);
        byte[] checksum = new byte[16];
        System.arraycopy(ciphertext, start, checksum, 0, 16);
        byte[] k3 = this.getHmac(k2, checksum);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKey = new SecretKeySpec(k3, "ARCFOUR");
        cipher.init(2, secretKey);
        byte[] plaintext = cipher.doFinal(ciphertext, start + 16, len - 16);
        byte[] calculatedHmac = this.getHmac(k2, plaintext);
        boolean cksumFailed = false;
        if (calculatedHmac.length >= 16) {
            for (int i = 0; i < 16; ++i) {
                if (calculatedHmac[i] == ciphertext[i]) continue;
                cksumFailed = true;
                System.err.println("Checksum failed !");
                break;
            }
        }
        if (cksumFailed) {
            throw new GeneralSecurityException("Checksum failed");
        }
        byte[] output = new byte[plaintext.length - this.confounderSize()];
        System.arraycopy(plaintext, this.confounderSize(), output, 0, output.length);
        return output;
    }

    protected byte[] getHmac(byte[] key, byte[] msg) throws GeneralSecurityException {
        SecretKeySpec keyKi = new SecretKeySpec(key, "HmacMD5");
        Mac m = Mac.getInstance("HmacMD5");
        m.init(keyKi);
        byte[] hash = m.doFinal(msg);
        return hash;
    }

    private byte[] getSalt(int usage) {
        int ms_usage = this.arcfour_translate_usage(usage);
        byte[] salt = new byte[]{(byte)(ms_usage & 0xFF), (byte)(ms_usage >> 8 & 0xFF), (byte)(ms_usage >> 16 & 0xFF), (byte)(ms_usage >> 24 & 0xFF)};
        return salt;
    }

    private int arcfour_translate_usage(int usage) {
        switch (usage) {
            case 3: {
                return 8;
            }
            case 9: {
                return 8;
            }
            case 23: {
                return 13;
            }
        }
        return usage;
    }

    public byte[] decryptedData(byte[] data) {
        return data;
    }
}

