/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.negotiation.KerberosLoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static Class<LoginModule> loadLoginModuleClass(String className) {
        return SecurityActions.loginModuleActions().loadLoginModuleClass(className);
    }

    static LoginModule newInstance(Class<LoginModule> moduleClass) {
        return SecurityActions.loginModuleActions().newInstance(moduleClass);
    }

    static void addPrivateCredential(Subject subject, Object credential) {
        SecurityActions.loginModuleActions().addPrivateCredential(subject, credential);
    }

    static void removePrivateCredential(Subject subject, Object credential) {
        SecurityActions.loginModuleActions().removePrivateCredential(subject, credential);
    }

    private static LoginModuleActions loginModuleActions() {
        return System.getSecurityManager() != null ? LoginModuleActions.PRIVILEGED : LoginModuleActions.NON_PRIVILEGED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LoginModuleActions {
        public static final LoginModuleActions NON_PRIVILEGED = new LoginModuleActions(){

            @Override
            public Class<LoginModule> loadLoginModuleClass(String className) {
                try {
                    return KerberosLoginModule.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                catch (ClassCastException e) {
                    return null;
                }
            }

            @Override
            public LoginModule newInstance(Class<LoginModule> moduleClass) {
                try {
                    return moduleClass.newInstance();
                }
                catch (InstantiationException e) {
                    return null;
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }

            @Override
            public void addPrivateCredential(Subject subject, Object credential) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                privateCredentials.add(credential);
            }

            @Override
            public void removePrivateCredential(Subject subject, Object credential) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                privateCredentials.remove(credential);
            }
        };
        public static final LoginModuleActions PRIVILEGED = new LoginModuleActions(){

            @Override
            public Class<LoginModule> loadLoginModuleClass(final String className) {
                return AccessController.doPrivileged(new PrivilegedAction<Class<LoginModule>>(){

                    @Override
                    public Class<LoginModule> run() {
                        return NON_PRIVILEGED.loadLoginModuleClass(className);
                    }
                });
            }

            @Override
            public LoginModule newInstance(final Class<LoginModule> moduleClass) {
                return AccessController.doPrivileged(new PrivilegedAction<LoginModule>(){

                    @Override
                    public LoginModule run() {
                        return NON_PRIVILEGED.newInstance(moduleClass);
                    }
                });
            }

            @Override
            public void addPrivateCredential(final Subject subject, final Object credential) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.addPrivateCredential(subject, credential);
                        return null;
                    }
                });
            }

            @Override
            public void removePrivateCredential(final Subject subject, final Object credential) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.removePrivateCredential(subject, credential);
                        return null;
                    }
                });
            }
        };

        public Class<LoginModule> loadLoginModuleClass(String var1);

        public LoginModule newInstance(Class<LoginModule> var1);

        public void addPrivateCredential(Subject var1, Object var2);

        public void removePrivateCredential(Subject var1, Object var2);
    }
}

