/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.jboss.security.negotiation.Constants;
import org.jboss.security.negotiation.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosLoginModule
implements LoginModule {
    public static final String ADD_GSS_CREDENTIAL = "addGSSCredential";
    public static final String CREDENTIAL_LIFETIME = "credentialLifetime";
    private static final String SUN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String IBM_MODULE = "com.ibm.security.auth.module.Krb5LoginModule";
    private static Class<LoginModule> WRAPPED_CLASS;
    private boolean addGssCredential;
    private int credentialLifetime = 0;
    private LoginModule wrapped;
    private Subject subject;
    private GSSCredential credential;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.wrapped = SecurityActions.newInstance(WRAPPED_CLASS);
        if (this.wrapped == null) {
            throw new IllegalStateException("Unable to instantiate Krb5LoginModule to wrap!");
        }
        HashMap tweakedOptions = new HashMap(options);
        tweakedOptions.remove(ADD_GSS_CREDENTIAL);
        tweakedOptions.remove(CREDENTIAL_LIFETIME);
        this.wrapped.initialize(subject, callbackHandler, sharedState, tweakedOptions);
        this.subject = subject;
        this.addGssCredential = Boolean.parseBoolean((String)options.get(ADD_GSS_CREDENTIAL));
        if (options.containsKey(CREDENTIAL_LIFETIME)) {
            if (!this.addGssCredential) {
                throw new IllegalStateException(String.format("Option '%s' has been specified within enabling '%s'", CREDENTIAL_LIFETIME, ADD_GSS_CREDENTIAL));
            }
            this.credentialLifetime = Integer.parseInt((String)options.get(CREDENTIAL_LIFETIME));
            if (this.credentialLifetime < 0) {
                this.credentialLifetime = Integer.MAX_VALUE;
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        return this.wrapped.login();
    }

    @Override
    public boolean commit() throws LoginException {
        boolean response = this.wrapped.commit();
        if (response && this.addGssCredential) {
            final GSSManager manager = GSSManager.getInstance();
            try {
                GSSCredential credential = Subject.doAs(this.subject, new PrivilegedExceptionAction<GSSCredential>(){

                    @Override
                    public GSSCredential run() throws Exception {
                        Set<KerberosPrincipal> principals = KerberosLoginModule.this.subject.getPrincipals(KerberosPrincipal.class);
                        if (principals.size() < 1) {
                            throw new LoginException("No KerberosPrincipal Found");
                        }
                        if (principals.size() > 1) {
                            throw new LoginException("Too Many KerberosPrincipals Found");
                        }
                        KerberosPrincipal principal = principals.iterator().next();
                        GSSName name = manager.createName(principal.getName(), GSSName.NT_USER_NAME, Constants.KERBEROS_V5);
                        return manager.createCredential(name, KerberosLoginModule.this.credentialLifetime, Constants.KERBEROS_V5, 1);
                    }
                });
                SecurityActions.addPrivateCredential(this.subject, credential);
                this.credential = credential;
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                if (cause instanceof LoginException) {
                    throw (LoginException)cause;
                }
                throw new LoginException("Unable to create GSSCredential");
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean abort() throws LoginException {
        try {
            boolean bl = this.wrapped.abort();
            return bl;
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logout() throws LoginException {
        try {
            if (this.credential != null) {
                SecurityActions.removePrivateCredential(this.subject, this.credential);
            }
            boolean bl = this.wrapped.abort();
            return bl;
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        this.wrapped = null;
        this.subject = null;
        if (this.credential != null) {
            try {
                this.credential.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
            this.credential = null;
        }
    }

    static {
        Class<LoginModule> wrappedClass = SecurityActions.loadLoginModuleClass(SUN_MODULE);
        if (wrappedClass == null) {
            wrappedClass = SecurityActions.loadLoginModuleClass(IBM_MODULE);
        }
        if (wrappedClass == null) {
            throw new IllegalStateException("Unable to locate any Krb5LoginModule");
        }
        WRAPPED_CLASS = wrappedClass;
    }
}

