/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.net;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.Principal;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.common.MessageTrace;
import org.jboss.security.negotiation.common.NegotiationContext;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInit;
import org.jboss.security.negotiation.spnego.encoding.NegTokenTarg;
import org.jboss.security.negotiation.spnego.encoding.TokenParser;
import org.jboss.security.plugins.JaasSecurityManager;

public class SPNEGOServerSocket
extends ServerSocket {
    private static Logger log = Logger.getLogger(SPNEGOServerSocket.class);
    private Principal principal;
    private String securityDomain;
    private String hostSecurityDomain;
    private LoginContext lc;
    private Subject subject;

    public SPNEGOServerSocket() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating " + this.getClass().getName()));
        }
    }

    public SPNEGOServerSocket(int port) throws IOException {
        super(port);
    }

    public SPNEGOServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public SPNEGOServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
    }

    public Socket accept() throws IOException {
        boolean TRACE = log.isTraceEnabled();
        if (TRACE) {
            log.trace((Object)(this.getClass().getName() + ".accept()"));
        }
        Socket socket = super.accept();
        if (TRACE) {
            log.trace((Object)"Creating new NegotiationContext");
        }
        NegotiationContext negotiationContext = new NegotiationContext();
        try {
            negotiationContext.associate();
            this.acceptSocket(socket, negotiationContext);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            negotiationContext.clear();
        }
        return socket;
    }

    public void close() throws IOException {
        try {
            this.logout();
        }
        catch (LoginException le) {
            log.error((Object)("Error during logout: " + le.getMessage()), (Throwable)le);
        }
        super.close();
    }

    protected void acceptSocket(Socket socket, NegotiationContext negotiationContext) throws Exception {
        boolean TRACE = log.isTraceEnabled();
        byte[] token = new byte[]{};
        DataInputStream inStream = new DataInputStream(socket.getInputStream());
        token = new byte[inStream.readInt()];
        if (TRACE) {
            log.debug((Object)("Receiving token of length " + token.length));
        }
        inStream.readFully(token);
        MessageTrace.logRequestHex((byte[])token);
        ByteArrayInputStream authTokenIS = new ByteArrayInputStream(token);
        MessageFactory mf = MessageFactory.newInstance();
        if (!mf.accepts((InputStream)authTokenIS)) {
            throw new IOException("Unsupported negotiation mechanism.");
        }
        NegotiationMessage requestMessage = mf.createMessage((InputStream)authTokenIS);
        authTokenIS.close();
        byte[] kerberosToken = ((NegTokenInit)requestMessage).getMechToken();
        ((NegTokenInit)requestMessage).setMechToken(token);
        negotiationContext.setRequestMessage(requestMessage);
        if (this.subject == null) {
            if (TRACE) {
                log.trace((Object)"Starting host login");
            }
            this.subject = this.login();
            if (TRACE) {
                log.trace((Object)"Host login successful");
            }
        }
        this.principal = this.getClientPrincipal(kerberosToken, this.subject);
        if (TRACE) {
            log.trace((Object)"Flushing cache");
        }
        this.flushPrincipalFromCache(this.principal, this.securityDomain);
        this.isValid(this.principal, null, this.securityDomain);
        NegotiationMessage responseMessage = negotiationContext.getResponseMessage();
        DataOutputStream outStream = new DataOutputStream(socket.getOutputStream());
        token = ((NegTokenTarg)responseMessage).getResponseToken();
        if (TRACE) {
            log.debug((Object)("Sending token of length " + token.length));
        }
        MessageTrace.logResponseHex((byte[])token);
        outStream.writeInt(token.length);
        outStream.write(token);
        outStream.flush();
    }

    protected boolean isValid(Principal principal, Object credential, String securityDomain) throws Exception {
        InitialContext ctx = new InitialContext();
        JaasSecurityManager jsm = (JaasSecurityManager)ctx.lookup("java:/jaas/" + securityDomain);
        return jsm.isValid(principal, credential);
    }

    protected void flushPrincipalFromCache(Principal principal, String securityDomain) throws Exception {
        MBeanServer server = MBeanServerLocator.locateJBoss();
        ObjectName jaasMgr = new ObjectName("jboss.security:service=JaasSecurityManager");
        Object[] params = new Object[]{securityDomain, principal};
        String[] signature = new String[]{String.class.getName(), Principal.class.getName()};
        server.invoke(jaasMgr, "flushAuthenticationCache", params, signature);
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public String getHostSecurityDomain() {
        return this.hostSecurityDomain;
    }

    public void setHostSecurityDomain(String hostSecurityDomain) {
        this.hostSecurityDomain = hostSecurityDomain;
    }

    protected Subject login() throws LoginException {
        if (this.lc == null) {
            this.lc = new LoginContext(this.hostSecurityDomain, (CallbackHandler)new SecurityAssociationHandler());
        }
        this.lc.login();
        return this.lc.getSubject();
    }

    protected void logout() throws LoginException {
        if (this.lc != null) {
            this.lc.logout();
        }
        this.subject = null;
    }

    protected Principal getClientPrincipal(byte[] ticket, Subject subject) {
        TokenParser tp = new TokenParser();
        try {
            tp.parseToken(ticket, subject);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing/decoding ticket: " + e.getMessage()), (Throwable)e);
            return null;
        }
        String principalName = tp.getPrincipalName();
        return new KerberosPrincipal(principalName);
    }
}

