/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.ntlm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.ntlm.Constants;
import org.jboss.security.negotiation.ntlm.encoding.NegotiateMessageDecoder;

public class NTLMMessageFactory
extends MessageFactory {
    public boolean accepts(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("The passed in InputStream needs to support mark/reset.");
        }
        byte[] expected = Constants.SIGNATURE;
        byte[] dataRead = new byte[expected.length];
        in.mark(dataRead.length);
        in.read(dataRead);
        in.reset();
        return Arrays.equals(expected, dataRead);
    }

    public NegotiationMessage createMessage(InputStream in) throws IOException {
        if (this.accepts(in)) {
            return NegotiateMessageDecoder.decode(in);
        }
        throw new IllegalArgumentException("InputStream does not contain NTLM message.");
    }
}

