/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.toolkit;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jboss.security.negotiation.OidNameUtil;
import org.jboss.security.negotiation.spnego.encoding.DebugHelper;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInit;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInitDecoder;
import org.jboss.util.Base64;

public class BasicNegotiationServlet
extends HttpServlet {
    private static final long serialVersionUID = 7269693410644316525L;
    private static final Logger log = Logger.getLogger(BasicNegotiationServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String authHeader = req.getHeader("Authorization");
        if (authHeader == null) {
            log.info((Object)"No Authorization Header, sending 401");
            resp.setHeader("WWW-Authenticate", "Negotiate");
            resp.sendError(401);
            return;
        }
        log.info((Object)"Authorization header received - formatting web page response.");
        PrintWriter writer = resp.getWriter();
        writer.println("<html>");
        writer.println("  <head>");
        writer.println("    <title>Negotiation Toolkit</title>");
        writer.println("  </head>");
        writer.println("  <body>");
        writer.println("    <h1>Negotiation Toolkit</h1>");
        writer.println("    <h2>Basic Negotiation</h2>");
        writer.println("    <p>WWW-Authenticate - ");
        writer.println(authHeader);
        writer.println("    </p>");
        try {
            this.writeHeaderDetail(authHeader, writer);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException("Unable to writeHeaderDetail", (Throwable)e);
        }
        writer.println("  </body>");
        writer.println("</html>");
        writer.flush();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void writeHeaderDetail(String authHeader, PrintWriter writer) throws IOException, GSSException {
        if (!authHeader.startsWith("Negotiate ")) {
            writer.println("<p><b>Header WWW-Authenticate does not beging with 'Negotiate'!</b></p>");
            return;
        }
        String requestHeader = authHeader.substring(10);
        byte[] reqToken = Base64.decode((String)requestHeader);
        if (reqToken[0] == 96) {
            NegTokenInit negTokenInit = NegTokenInitDecoder.decode((byte[])reqToken);
            writer.println("<h3>NegTokenInit</h3>");
            writer.print("<b>Message Oid - </b>");
            writer.print(OidNameUtil.getName((Oid)negTokenInit.getMessageOid()));
            writer.println("<br>");
            List mechTypes = negTokenInit.getMechTypes();
            writer.print("<b>Mech Types -</b>");
            for (Oid current : mechTypes) {
                writer.print(" {");
                writer.print(OidNameUtil.getName((Oid)current));
                writer.print("}");
            }
            writer.println("<br>");
            writer.print("<b>Req Flags -</b>");
            byte[] reqFlags = negTokenInit.getReqFlags();
            if (reqFlags != null && reqFlags.length > 0) {
                writer.print(DebugHelper.convertToHex((byte[])reqFlags));
            }
            writer.println("<br>");
            writer.print("<b>Mech Token -</b>");
            byte[] mechToken = negTokenInit.getMechToken();
            if (mechToken != null && mechToken.length > 0) {
                writer.print(new String(Base64.encodeBytes((byte[])mechToken)));
            }
            writer.println("<br>");
            writer.print("<b>Mech List Mic -</b>");
            byte[] mechTokenMic = negTokenInit.getMechListMIC();
            if (mechTokenMic != null && mechTokenMic.length > 0) {
                writer.print(new String(Base64.encodeBytes((byte[])mechTokenMic)));
            }
        } else {
            if (reqToken[0] == -95) {
                writer.println("<p><b>Unexpected NegTokenTarg, first token should be NegTokenInit!</b></p>");
                return;
            }
            writer.println("<p><b>Unsupported negotiation mechanism, possibly NTLM!</b></p>");
            return;
        }
        writer.println("<br>");
    }
}

