/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.toolkit;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSCredential;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SubjectInfo;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.Role;
import org.jboss.security.negotiation.DelegationCredentialContext;

public class SecuredServlet
extends HttpServlet {
    private static final long serialVersionUID = 4708999345009728352L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean goAsyc = Boolean.parseBoolean(req.getParameter("async"));
        if (goAsyc) {
            AsyncContext asyncContext = req.startAsync();
            asyncContext.start(() -> {
                try {
                    this.writeResponse(req, resp, true);
                    asyncContext.complete();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            this.writeResponse(req, resp, false);
        }
    }

    private void writeResponse(HttpServletRequest req, HttpServletResponse resp, boolean async) throws IOException {
        PrintWriter writer = resp.getWriter();
        writer.println("<html>");
        writer.println("  <head>");
        writer.println("    <title>Negotiation Toolkit</title>");
        writer.println("  </head>");
        writer.println("  <body>");
        writer.println("    <h1>Negotiation Toolkit</h1>");
        writer.println("    <h2>Secured");
        if (async) {
            writer.println(" (Asynchronous)");
        }
        writer.println("</h2>");
        writer.println("    <h5>Auth Type</h5>");
        this.writeObject((Object)req.getAuthType(), writer);
        writer.println("    <h5>User Principal</h5>");
        this.writeObject((Object)req.getUserPrincipal(), writer);
        SubjectInfo info = SecurityContextAssociation.getSecurityContext().getSubjectInfo();
        Set identities = info.getIdentities();
        writer.println("    <h5>Identities</h5>");
        for (Identity current : identities) {
            writer.println(" " + current.getName() + "<br>");
        }
        writer.println("    <h5>Delegation Credential</h5>");
        GSSCredential credential = DelegationCredentialContext.getDelegCredential();
        if (credential == null) {
            writer.println("    <p>None</p>");
        } else {
            this.writeObject((Object)credential, writer);
        }
        writer.println("    <h5>Subject</h5>");
        this.writeObject((Object)info.getAuthenticatedSubject(), writer);
        Collection roles = info.getRoles().getRoles();
        writer.println("    <h5>Roles</h5>");
        for (Role current : roles) {
            writer.println(" " + current.getRoleName() + "<br>");
        }
        writer.println("  </body>");
        writer.println("</html>");
        writer.flush();
    }

    private void writeObject(Object obj, PrintWriter writer) throws IOException {
        String currentLine;
        ByteArrayInputStream bais = new ByteArrayInputStream(String.valueOf(obj).getBytes());
        InputStreamReader isr = new InputStreamReader(bais);
        BufferedReader br = new BufferedReader(isr);
        writer.println("<code>");
        while ((currentLine = br.readLine()) != null) {
            writer.print(currentLine);
            writer.println("<br>");
        }
        writer.println("</code>");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

