/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego;

import java.io.IOException;
import java.security.Principal;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.jboss.security.negotiation.spnego.SPNEGOContext;

public class SPNEGOAuthenticator
extends AuthenticatorBase {
    private static final Logger log = Logger.getLogger(SPNEGOAuthenticator.class);
    private static final String SPNEGO = "SPNEGO";
    private static final String SPNEGO_CONTEXT = "SPNEGO_CONTEXT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        log.trace((Object)"Authenticating user");
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            return true;
        }
        log.info((Object)("Header - " + request.getHeader("Authorization")));
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            log.debug((Object)"No Authorization Header, sending 401");
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return false;
        }
        if (!authHeader.startsWith("Negotiate ")) {
            throw new IOException("Invalid 'Authorization' header.");
        }
        Session session = request.getSessionInternal();
        SPNEGOContext spnegoContext = (SPNEGOContext)session.getNote(SPNEGO_CONTEXT);
        if (spnegoContext == null) {
            log.debug((Object)"Creating new SPNEGOContext");
            spnegoContext = new SPNEGOContext();
            session.setNote(SPNEGO_CONTEXT, (Object)spnegoContext);
        }
        String username = session.getId();
        try {
            String responseHeader;
            spnegoContext.associate();
            spnegoContext.setRequestHeader(authHeader.substring(10));
            Realm realm = this.context.getRealm();
            principal = realm.authenticate(username, (String)null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("authenticated principal = " + principal));
            }
            if ((responseHeader = spnegoContext.getResponseHeader()) != null) {
                response.setHeader("WWW-Authenticate", "Negotiate " + responseHeader);
            }
        }
        finally {
            spnegoContext.clear();
        }
        if (principal == null) {
            response.sendError(401);
        } else {
            this.register(request, response, principal, SPNEGO, username, null);
        }
        return principal != null;
    }
}

