/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego.encoding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jboss.security.negotiation.spnego.encoding.NegTokenDecoder;
import org.jboss.security.negotiation.spnego.encoding.NegTokenTarg;

public class NegTokenTargDecoder
extends NegTokenDecoder {
    private static void decodeNegResult(InputStream is, NegTokenTarg negTokenTarg) throws IOException {
        int length = NegTokenTargDecoder.readLength(is);
        byte type = (byte)is.read();
        byte negResult = (byte)is.read();
        switch (negResult) {
            case 0: {
                negTokenTarg.setNegResult(NegTokenTarg.ACCEPT_COMPLETED);
                break;
            }
            case 1: {
                negTokenTarg.setNegResult(NegTokenTarg.ACCEPT_INCOMPLETE);
                break;
            }
            case 2: {
                negTokenTarg.setNegResult(NegTokenTarg.REJECTED);
                break;
            }
            default: {
                throw new IOException("Unexpected negResult");
            }
        }
    }

    private static void decodeSupportedMech(InputStream is, NegTokenTarg negTokenTarg) throws IOException, GSSException {
        int length = NegTokenTargDecoder.readLength(is);
        negTokenTarg.setSupportedMech(new Oid(is));
    }

    private static void decodeResponseToken(InputStream is, NegTokenTarg negTokenTarg) throws IOException {
        int length = NegTokenTargDecoder.readLength(is);
        byte type = (byte)is.read();
        int tokenLength = NegTokenTargDecoder.readLength(is);
        byte[] responseToken = new byte[tokenLength];
        is.read(responseToken);
        negTokenTarg.setResponseToken(responseToken);
    }

    private static void decodeMechListMIC(InputStream is, NegTokenTarg negTokenTarg) throws IOException {
        int length = NegTokenTargDecoder.readLength(is);
        byte[] mechListMIC = new byte[length];
        is.read(mechListMIC);
        negTokenTarg.setMechListMIC(mechListMIC);
    }

    private static void decodeNegTokenTargSequence(InputStream is, NegTokenTarg negTokenTarg) throws IOException, GSSException {
        byte type = (byte)is.read();
        int sequenceLength = NegTokenTargDecoder.readLength(is);
        int leftAfter = is.available() - sequenceLength;
        block6: while (is.available() > leftAfter) {
            byte sequenceType = (byte)is.read();
            switch (sequenceType) {
                case -96: {
                    NegTokenTargDecoder.decodeNegResult(is, negTokenTarg);
                    continue block6;
                }
                case -95: {
                    NegTokenTargDecoder.decodeSupportedMech(is, negTokenTarg);
                    continue block6;
                }
                case -94: {
                    NegTokenTargDecoder.decodeResponseToken(is, negTokenTarg);
                    continue block6;
                }
                case -93: {
                    NegTokenTargDecoder.decodeMechListMIC(is, negTokenTarg);
                    continue block6;
                }
            }
            throw new IOException("Unexpected message type");
        }
    }

    public static NegTokenTarg decode(byte[] token) throws IOException, GSSException {
        NegTokenTarg negTokenTarg = new NegTokenTarg();
        ByteArrayInputStream bais = new ByteArrayInputStream(token);
        byte firstByte = (byte)bais.read();
        int totalLength = NegTokenTargDecoder.readLength(bais);
        NegTokenTargDecoder.decodeNegTokenTargSequence(bais, negTokenTarg);
        return negTokenTarg;
    }
}

