/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.javaee;

import org.jboss.security.SecurityContext;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.AbstractWebAuthorizationHelper;
import org.jboss.security.javaee.EJBAuthenticationHelper;
import org.jboss.security.javaee.SecurityActions;

public class SecurityHelperFactory {
    private static String WebAuthorizationHelperClass = "org.jboss.security.plugins.javaee.WebAuthorizationHelper";
    private static String EjbAuthorizationHelperClass = "org.jboss.security.plugins.javaee.EJBAuthorizationHelper";

    public static EJBAuthenticationHelper getEJBAuthenticationHelper(SecurityContext sc) {
        return new EJBAuthenticationHelper(sc);
    }

    public static AbstractWebAuthorizationHelper getWebAuthorizationHelper(SecurityContext sc) throws Exception {
        Class<?> clazz = SecurityActions.loadClass(WebAuthorizationHelperClass);
        AbstractWebAuthorizationHelper awh = (AbstractWebAuthorizationHelper)clazz.newInstance();
        awh.setSecurityContext(sc);
        return awh;
    }

    public static AbstractEJBAuthorizationHelper getEJBAuthorizationHelper(SecurityContext sc) throws Exception {
        Class<?> clazz = SecurityActions.loadClass(EjbAuthorizationHelperClass);
        AbstractEJBAuthorizationHelper awh = (AbstractEJBAuthorizationHelper)clazz.newInstance();
        awh.setSecurityContext(sc);
        return awh;
    }

    public static void setEJBAuthorizationHelperClass(String fqn) {
        EjbAuthorizationHelperClass = fqn;
    }

    public static void setWebAuthorizationHelperClass(String fqn) {
        WebAuthorizationHelperClass = fqn;
    }
}

