/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.security.xacml.sunxacml.PDPConfig;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactoryProxy;
import org.jboss.security.xacml.sunxacml.attr.AttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.BaseAttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.StandardAttributeFactory;
import org.jboss.security.xacml.sunxacml.combine.BaseCombiningAlgFactory;
import org.jboss.security.xacml.sunxacml.combine.CombiningAlgFactory;
import org.jboss.security.xacml.sunxacml.combine.CombiningAlgFactoryProxy;
import org.jboss.security.xacml.sunxacml.combine.CombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.combine.StandardCombiningAlgFactory;
import org.jboss.security.xacml.sunxacml.cond.BaseFunctionFactory;
import org.jboss.security.xacml.sunxacml.cond.BasicFunctionFactoryProxy;
import org.jboss.security.xacml.sunxacml.cond.Function;
import org.jboss.security.xacml.sunxacml.cond.FunctionFactory;
import org.jboss.security.xacml.sunxacml.cond.FunctionFactoryProxy;
import org.jboss.security.xacml.sunxacml.cond.FunctionProxy;
import org.jboss.security.xacml.sunxacml.cond.StandardFunctionFactory;
import org.jboss.security.xacml.sunxacml.cond.cluster.FunctionCluster;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.ResourceFinder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationStore {
    public static final String PDP_CONFIG_PROPERTY = "com.sun.xacml.PDPConfigFile";
    private PDPConfig defaultPDPConfig;
    private HashMap pdpConfigMap;
    private AttributeFactory defaultAttributeFactory;
    private HashMap attributeMap;
    private CombiningAlgFactory defaultCombiningFactory;
    private HashMap combiningMap;
    private FunctionFactoryProxy defaultFunctionFactoryProxy;
    private HashMap functionMap;
    private ClassLoader loader;
    private static final Logger logger = Logger.getLogger(ConfigurationStore.class.getName());

    public ConfigurationStore() throws ParsingException {
        String configFile = System.getProperty(PDP_CONFIG_PROPERTY);
        if (configFile == null) {
            logger.severe("A property defining a config file was expected, but none was provided");
            throw new ParsingException("Config property com.sun.xacml.PDPConfigFile needs to be set");
        }
        try {
            this.setupConfig(new File(configFile));
        }
        catch (ParsingException pe) {
            logger.log(Level.SEVERE, "Runtime config file couldn't be loaded so no configurations will be available", pe);
            throw pe;
        }
    }

    public ConfigurationStore(File configFile) throws ParsingException {
        try {
            this.setupConfig(configFile);
        }
        catch (ParsingException pe) {
            logger.log(Level.SEVERE, "Runtime config file couldn't be loaded so no configurations will be available", pe);
            throw pe;
        }
    }

    private void setupConfig(File configFile) throws ParsingException {
        logger.config("Loading runtime configuration");
        this.loader = this.getClass().getClassLoader();
        Node root = this.getRootNode(configFile);
        this.pdpConfigMap = new HashMap();
        this.attributeMap = new HashMap();
        this.combiningMap = new HashMap();
        this.functionMap = new HashMap();
        NamedNodeMap attrs = root.getAttributes();
        String defaultPDP = attrs.getNamedItem("defaultPDP").getNodeValue();
        String defaultAF = this.getDefaultFactory(attrs, "defaultAttributeFactory");
        String defaultCAF = this.getDefaultFactory(attrs, "defaultCombiningAlgFactory");
        String defaultFF = this.getDefaultFactory(attrs, "defaultFunctionFactory");
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            String elementName = null;
            if (child.getNodeType() == 1) {
                elementName = child.getAttributes().getNamedItem("name").getNodeValue();
            }
            if (childName.equals("pdp")) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Loading PDP: " + elementName);
                }
                if (this.pdpConfigMap.containsKey(elementName)) {
                    throw new ParsingException("more that one pdp with name \"" + elementName + "\"");
                }
                this.pdpConfigMap.put(elementName, this.parsePDPConfig(child));
                continue;
            }
            if (childName.equals("attributeFactory")) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Loading AttributeFactory: " + elementName);
                }
                if (this.attributeMap.containsKey(elementName)) {
                    throw new ParsingException("more that one attributeFactory with name " + elementName + "\"");
                }
                this.attributeMap.put(elementName, this.parseAttributeFactory(child));
                continue;
            }
            if (childName.equals("combiningAlgFactory")) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Loading CombiningAlgFactory: " + elementName);
                }
                if (this.combiningMap.containsKey(elementName)) {
                    throw new ParsingException("more that one combiningAlgFactory with name \"" + elementName + "\"");
                }
                this.combiningMap.put(elementName, this.parseCombiningAlgFactory(child));
                continue;
            }
            if (!childName.equals("functionFactory")) continue;
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("Loading FunctionFactory: " + elementName);
            }
            if (this.functionMap.containsKey(elementName)) {
                throw new ParsingException("more that one functionFactory with name \"" + elementName + "\"");
            }
            this.functionMap.put(elementName, this.parseFunctionFactory(child));
        }
        this.defaultPDPConfig = (PDPConfig)this.pdpConfigMap.get(defaultPDP);
        this.defaultAttributeFactory = (AttributeFactory)this.attributeMap.get(defaultAF);
        if (this.defaultAttributeFactory == null) {
            try {
                this.defaultAttributeFactory = AttributeFactory.getInstance(defaultAF);
            }
            catch (Exception e) {
                throw new ParsingException("Unknown AttributeFactory", e);
            }
        }
        this.defaultCombiningFactory = (CombiningAlgFactory)this.combiningMap.get(defaultCAF);
        if (this.defaultCombiningFactory == null) {
            try {
                this.defaultCombiningFactory = CombiningAlgFactory.getInstance(defaultCAF);
            }
            catch (Exception e) {
                throw new ParsingException("Unknown CombininAlgFactory", e);
            }
        }
        this.defaultFunctionFactoryProxy = (FunctionFactoryProxy)this.functionMap.get(defaultFF);
        if (this.defaultFunctionFactoryProxy == null) {
            try {
                this.defaultFunctionFactoryProxy = FunctionFactory.getInstance(defaultFF);
            }
            catch (Exception e) {
                throw new ParsingException("Unknown FunctionFactory", e);
            }
        }
    }

    private String getDefaultFactory(NamedNodeMap attrs, String factoryName) {
        Node node = attrs.getNamedItem(factoryName);
        if (node != null) {
            return node.getNodeValue();
        }
        return "urn:oasis:names:tc:xacml:1.0:policy";
    }

    private Node getRootNode(File configFile) throws ParsingException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setIgnoringComments(true);
        dbFactory.setNamespaceAware(false);
        dbFactory.setValidating(false);
        DocumentBuilder db = null;
        try {
            db = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new ParsingException("couldn't get a document builder", pce);
        }
        Document doc = null;
        try {
            doc = db.parse(new FileInputStream(configFile));
        }
        catch (IOException ioe) {
            throw new ParsingException("failed to load the file ", ioe);
        }
        catch (SAXException saxe) {
            throw new ParsingException("error parsing the XML tree", saxe);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException("no data to parse", iae);
        }
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("config")) {
            throw new ParsingException("unknown document type: " + root.getTagName());
        }
        return root;
    }

    private PDPConfig parsePDPConfig(Node root) throws ParsingException {
        ArrayList<Object> attrModules = new ArrayList<Object>();
        HashSet<Object> policyModules = new HashSet<Object>();
        ArrayList<Object> rsrcModules = new ArrayList<Object>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("policyFinderModule")) {
                policyModules.add(this.loadClass("module", child));
                continue;
            }
            if (name.equals("attributeFinderModule")) {
                attrModules.add(this.loadClass("module", child));
                continue;
            }
            if (!name.equals("resourceFinderModule")) continue;
            rsrcModules.add(this.loadClass("module", child));
        }
        AttributeFinder attrFinder = new AttributeFinder();
        attrFinder.setModules(attrModules);
        PolicyFinder policyFinder = new PolicyFinder();
        policyFinder.setModules(policyModules);
        ResourceFinder rsrcFinder = new ResourceFinder();
        rsrcFinder.setModules(rsrcModules);
        return new PDPConfig(attrFinder, policyFinder, rsrcFinder);
    }

    private AttributeFactory parseAttributeFactory(Node root) throws ParsingException {
        AttributeFactory factory = null;
        if (this.useStandard(root, "useStandardDatatypes")) {
            logger.config("Starting with standard Datatypes");
            factory = StandardAttributeFactory.getNewFactory();
        } else {
            factory = new BaseAttributeFactory();
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("datatype")) continue;
            String identifier = child.getAttributes().getNamedItem("identifier").getNodeValue();
            AttributeProxy proxy = (AttributeProxy)this.loadClass("datatype", child);
            try {
                factory.addDatatype(identifier, proxy);
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw new ParsingException("duplicate datatype: " + identifier, iae);
            }
        }
        return factory;
    }

    private CombiningAlgFactory parseCombiningAlgFactory(Node root) throws ParsingException {
        CombiningAlgFactory factory = null;
        if (this.useStandard(root, "useStandardAlgorithms")) {
            logger.config("Starting with standard Combining Algorithms");
            factory = StandardCombiningAlgFactory.getNewFactory();
        } else {
            factory = new BaseCombiningAlgFactory();
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("algorithm")) continue;
            CombiningAlgorithm alg = (CombiningAlgorithm)this.loadClass("algorithm", child);
            try {
                factory.addAlgorithm(alg);
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw new ParsingException("duplicate combining algorithm: " + alg.getIdentifier().toString(), iae);
            }
        }
        return factory;
    }

    private FunctionFactoryProxy parseFunctionFactory(Node root) throws ParsingException {
        FunctionFactoryProxy proxy = null;
        FunctionFactory generalFactory = null;
        FunctionFactory conditionFactory = null;
        FunctionFactory targetFactory = null;
        if (this.useStandard(root, "useStandardFunctions")) {
            logger.config("Starting with standard Functions");
            proxy = StandardFunctionFactory.getNewFactoryProxy();
            targetFactory = proxy.getTargetFactory();
            conditionFactory = proxy.getConditionFactory();
            generalFactory = proxy.getGeneralFactory();
        } else {
            generalFactory = new BaseFunctionFactory();
            conditionFactory = new BaseFunctionFactory(generalFactory);
            targetFactory = new BaseFunctionFactory(conditionFactory);
            proxy = new BasicFunctionFactoryProxy(targetFactory, conditionFactory, generalFactory);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("target")) {
                logger.config("Loading [TARGET] functions");
                this.functionParserHelper(child, targetFactory);
                continue;
            }
            if (name.equals("condition")) {
                logger.config("Loading [CONDITION] functions");
                this.functionParserHelper(child, conditionFactory);
                continue;
            }
            if (!name.equals("general")) continue;
            logger.config("Loading [GENERAL] functions");
            this.functionParserHelper(child, generalFactory);
        }
        return proxy;
    }

    private void functionParserHelper(Node root, FunctionFactory factory) throws ParsingException {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("function")) {
                Function function = (Function)this.loadClass("function", child);
                try {
                    factory.addFunction(function);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new ParsingException("duplicate function", iae);
                }
            }
            if (name.equals("abstractFunction")) {
                URI identifier = null;
                try {
                    identifier = new URI(child.getAttributes().getNamedItem("identifier").getNodeValue());
                }
                catch (URISyntaxException urise) {
                    throw new ParsingException("invalid function identifier", urise);
                }
                FunctionProxy proxy = (FunctionProxy)this.loadClass("abstract function", child);
                try {
                    factory.addAbstractFunction(proxy, identifier);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new ParsingException("duplicate abstract function", iae);
                }
            }
            if (!name.equals("functionCluster")) continue;
            FunctionCluster cluster = (FunctionCluster)this.loadClass("function cluster", child);
            Iterator it = cluster.getSupportedFunctions().iterator();
            while (it.hasNext()) {
                try {
                    factory.addFunction((Function)it.next());
                }
                catch (IllegalArgumentException iae) {
                    throw new ParsingException("duplicate function", iae);
                }
            }
        }
    }

    private Object loadClass(String prefix, Node root) throws ParsingException {
        String className = root.getAttributes().getNamedItem("class").getNodeValue();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Loading [ " + prefix + ": " + className + " ]");
        }
        Class<?> c = null;
        try {
            c = this.loader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ParsingException("couldn't load class " + className, cnfe);
        }
        Object instance = null;
        if (!root.hasChildNodes()) {
            try {
                instance = c.newInstance();
            }
            catch (InstantiationException ie) {
                throw new ParsingException("couldn't instantiate " + className + " with empty constructor", ie);
            }
            catch (IllegalAccessException iae) {
                throw new ParsingException("couldn't get access to instance of " + className, iae);
            }
        }
        List args = null;
        try {
            args = this.getArgs(root);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException("illegal class arguments", iae);
        }
        int argLength = args.size();
        Constructor<?>[] cons = c.getConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < cons.length; ++i) {
            Class<?>[] params = cons[i].getParameterTypes();
            if (params.length == argLength) {
                Iterator it = args.iterator();
                int j = 0;
                while (it.hasNext() && params[j].isAssignableFrom(it.next().getClass())) {
                    ++j;
                }
                if (j == argLength) {
                    constructor = cons[i];
                }
            }
            if (constructor != null) break;
        }
        if (constructor == null) {
            throw new ParsingException("couldn't find a matching constructor");
        }
        try {
            instance = constructor.newInstance(args.toArray());
        }
        catch (InstantiationException ie) {
            throw new ParsingException("couldn't instantiate " + className, ie);
        }
        catch (IllegalAccessException iae) {
            throw new ParsingException("couldn't get access to instance of " + className, iae);
        }
        catch (InvocationTargetException ite) {
            throw new ParsingException("couldn't create " + className, ite);
        }
        return instance;
    }

    private List getArgs(Node root) {
        ArrayList<Object> args = new ArrayList<Object>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (child.getNodeType() != 1) continue;
            if (name.equals("string")) {
                args.add(child.getFirstChild().getNodeValue());
                continue;
            }
            if (name.equals("list")) {
                args.add(this.getArgs(child));
                continue;
            }
            throw new IllegalArgumentException("unkown arg type: " + name);
        }
        return args;
    }

    private boolean useStandard(Node node, String attributeName) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return true;
        }
        Node attrNode = map.getNamedItem(attributeName);
        if (attrNode == null) {
            return true;
        }
        return attrNode.getNodeValue().equals("true");
    }

    public PDPConfig getDefaultPDPConfig() throws UnknownIdentifierException {
        if (this.defaultPDPConfig == null) {
            throw new UnknownIdentifierException("no default available");
        }
        return this.defaultPDPConfig;
    }

    public PDPConfig getPDPConfig(String name) throws UnknownIdentifierException {
        Object object = this.pdpConfigMap.get(name);
        if (object == null) {
            throw new UnknownIdentifierException("unknown pdp: " + name);
        }
        return (PDPConfig)object;
    }

    public Set getSupportedPDPConfigurations() {
        return Collections.unmodifiableSet(this.pdpConfigMap.keySet());
    }

    public AttributeFactory getDefaultAttributeFactory() {
        return this.defaultAttributeFactory;
    }

    public AttributeFactory getAttributeFactory(String name) throws UnknownIdentifierException {
        Object object = this.attributeMap.get(name);
        if (object == null) {
            throw new UnknownIdentifierException("unknown factory: " + name);
        }
        return (AttributeFactory)object;
    }

    public Set getSupportedAttributeFactories() {
        return Collections.unmodifiableSet(this.attributeMap.keySet());
    }

    public void registerAttributeFactories() {
        for (String id : this.attributeMap.keySet()) {
            AttributeFactory af = (AttributeFactory)this.attributeMap.get(id);
            try {
                AttributeFactory.registerFactory(id, new AFProxy(af));
            }
            catch (IllegalArgumentException iae) {
                logger.log(Level.WARNING, "Couldn't register AttributeFactory:" + id + " (already in use)", iae);
            }
        }
    }

    public CombiningAlgFactory getDefaultCombiningAlgFactory() {
        return this.defaultCombiningFactory;
    }

    public CombiningAlgFactory getCombiningAlgFactory(String name) throws UnknownIdentifierException {
        Object object = this.combiningMap.get(name);
        if (object == null) {
            throw new UnknownIdentifierException("unknown factory: " + name);
        }
        return (CombiningAlgFactory)object;
    }

    public Set getSupportedCombiningAlgFactories() {
        return Collections.unmodifiableSet(this.combiningMap.keySet());
    }

    public void registerCombiningAlgFactories() {
        for (String id : this.combiningMap.keySet()) {
            CombiningAlgFactory cf = (CombiningAlgFactory)this.combiningMap.get(id);
            try {
                CombiningAlgFactory.registerFactory(id, new CAFProxy(cf));
            }
            catch (IllegalArgumentException iae) {
                logger.log(Level.WARNING, "Couldn't register CombiningAlgFactory: " + id + " (already in use)", iae);
            }
        }
    }

    public FunctionFactoryProxy getDefaultFunctionFactoryProxy() {
        return this.defaultFunctionFactoryProxy;
    }

    public FunctionFactoryProxy getFunctionFactoryProxy(String name) throws UnknownIdentifierException {
        Object object = this.functionMap.get(name);
        if (object == null) {
            throw new UnknownIdentifierException("unknown factory: " + name);
        }
        return (FunctionFactoryProxy)object;
    }

    public Set getSupportedFunctionFactories() {
        return Collections.unmodifiableSet(this.functionMap.keySet());
    }

    public void registerFunctionFactories() {
        for (String id : this.functionMap.keySet()) {
            FunctionFactoryProxy ffp = (FunctionFactoryProxy)this.functionMap.get(id);
            try {
                FunctionFactory.registerFactory(id, ffp);
            }
            catch (IllegalArgumentException iae) {
                logger.log(Level.WARNING, "Couldn't register FunctionFactory: " + id + " (already in use)", iae);
            }
        }
    }

    public void useDefaultFactories() {
        logger.fine("Switching to default factories from configuration");
        if (this.defaultAttributeFactory != null) {
            AttributeFactory.setDefaultFactory(new AFProxy(this.defaultAttributeFactory));
        }
        if (this.defaultCombiningFactory != null) {
            CombiningAlgFactory.setDefaultFactory(new CAFProxy(this.defaultCombiningFactory));
        }
        if (this.defaultFunctionFactoryProxy != null) {
            FunctionFactory.setDefaultFactory(this.defaultFunctionFactoryProxy);
        }
    }

    class CAFProxy
    implements CombiningAlgFactoryProxy {
        private CombiningAlgFactory factory;

        public CAFProxy(CombiningAlgFactory factory) {
            this.factory = factory;
        }

        public CombiningAlgFactory getFactory() {
            return this.factory;
        }
    }

    class AFProxy
    implements AttributeFactoryProxy {
        private AttributeFactory factory;

        public AFProxy(AttributeFactory factory) {
            this.factory = factory;
        }

        public AttributeFactory getFactory() {
            return this.factory;
        }
    }
}

