/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.Rule;
import org.jboss.security.xacml.sunxacml.Target;
import org.jboss.security.xacml.sunxacml.combine.CombinerParameter;
import org.jboss.security.xacml.sunxacml.combine.RuleCombinerElement;
import org.jboss.security.xacml.sunxacml.combine.RuleCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.cond.VariableDefinition;
import org.jboss.security.xacml.sunxacml.cond.VariableManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Policy
extends AbstractPolicy {
    private Set definitions;

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, Target target) {
        this(id, null, combiningAlg, null, target, null, null, null);
    }

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, Target target, List rules) {
        this(id, null, combiningAlg, null, target, null, rules, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, List rules) {
        this(id, version, combiningAlg, description, target, null, rules, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List rules) {
        this(id, version, combiningAlg, description, target, defaultVersion, rules, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List rules, Set obligations) {
        this(id, version, combiningAlg, description, target, defaultVersion, rules, obligations, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List rules, Set obligations, Set definitions) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, null);
        ArrayList<RuleCombinerElement> list = null;
        if (rules != null) {
            list = new ArrayList<RuleCombinerElement>();
            for (Object o : rules) {
                if (!(o instanceof Rule)) {
                    throw new IllegalArgumentException("non-Rule in rules");
                }
                list.add(new RuleCombinerElement((Rule)o));
            }
        }
        this.setChildren(list);
        this.definitions = definitions == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(definitions));
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List ruleElements, Set obligations, Set definitions, List parameters) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, parameters);
        if (ruleElements != null) {
            for (Object o : ruleElements) {
                if (o instanceof RuleCombinerElement) continue;
                throw new IllegalArgumentException("non-Rule in rules");
            }
        }
        this.setChildren(ruleElements);
        this.definitions = definitions == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(definitions));
    }

    private Policy(Node root) throws ParsingException {
        super(root, "Policy", "RuleCombiningAlgId");
        String id;
        List list;
        ArrayList<Rule> rules = new ArrayList<Rule>();
        HashMap parameters = new HashMap();
        HashMap<String, Node> variableIds = new HashMap<String, Node>();
        PolicyMetaData metaData = this.getMetaData();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("VariableDefinition")) continue;
            String id2 = child.getAttributes().getNamedItem("VariableId").getNodeValue();
            if (variableIds.containsKey(id2)) {
                throw new ParsingException("multiple definitions for variable " + id2);
            }
            variableIds.put(id2, child);
        }
        VariableManager manager = new VariableManager(variableIds, metaData);
        this.definitions = new HashSet();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("Rule")) {
                rules.add(Rule.getInstance(child, metaData, manager));
                continue;
            }
            if (name.equals("RuleCombinerParameters")) {
                String ref = child.getAttributes().getNamedItem("RuleIdRef").getNodeValue();
                if (parameters.containsKey(ref)) {
                    list = (List)parameters.get(ref);
                    this.parseParameters(list, child);
                    continue;
                }
                list = new ArrayList();
                this.parseParameters(list, child);
                parameters.put(ref, list);
                continue;
            }
            if (!name.equals("VariableDefinition")) continue;
            id = child.getAttributes().getNamedItem("VariableId").getNodeValue();
            this.definitions.add(manager.getDefinition(id));
        }
        this.definitions = Collections.unmodifiableSet(this.definitions);
        ArrayList<RuleCombinerElement> elements = new ArrayList<RuleCombinerElement>();
        for (Rule rule : rules) {
            id = rule.getId().toString();
            list = (List)parameters.remove(id);
            elements.add(new RuleCombinerElement(rule, list));
        }
        if (!parameters.isEmpty()) {
            throw new ParsingException("Unmatched parameters in Rule");
        }
        this.setChildren(elements);
    }

    private void parseParameters(List parameters, Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("CombinerParameter")) continue;
            parameters.add(CombinerParameter.getInstance(node));
        }
    }

    public static Policy getInstance(Node root) throws ParsingException {
        if (!root.getNodeName().equals("Policy")) {
            throw new ParsingException("Cannot create Policy from root of type " + root.getNodeName());
        }
        return new Policy(root);
    }

    public Set getVariableDefinitions() {
        return this.definitions;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        String version;
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Policy PolicyId=\"" + this.getId().toString() + "\" RuleCombiningAlgId=\"" + this.getCombiningAlg().getIdentifier().toString() + "\">");
        indenter.in();
        String nextIndent = indenter.makeString();
        String description = this.getDescription();
        if (description != null) {
            out.println(nextIndent + "<Description>" + description + "</Description>");
        }
        if ((version = this.getDefaultVersion()) != null) {
            out.println("<PolicyDefaults><XPathVersion>" + version + "</XPathVersion></PolicyDefaults>");
        }
        this.getTarget().encode(output, indenter);
        Iterator it = this.definitions.iterator();
        while (it.hasNext()) {
            ((VariableDefinition)it.next()).encode(output, indenter);
        }
        this.encodeCommonElements(output, indenter);
        indenter.out();
        out.println(indent + "</Policy>");
    }
}

