/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.PolicyReference;
import org.jboss.security.xacml.sunxacml.Target;
import org.jboss.security.xacml.sunxacml.combine.CombinerParameter;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombinerElement;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicySet
extends AbstractPolicy {
    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, Target target) {
        this(id, null, combiningAlg, null, target, null, null, null);
    }

    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, Target target, List policies) {
        this(id, null, combiningAlg, null, target, policies, null, null);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policies) {
        this(id, version, combiningAlg, description, target, policies, null, null);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policies, String defaultVersion) {
        this(id, version, combiningAlg, description, target, policies, defaultVersion, null);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policies, String defaultVersion, Set obligations) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, null);
        ArrayList<PolicyCombinerElement> list = null;
        if (policies != null) {
            list = new ArrayList<PolicyCombinerElement>();
            for (Object o : policies) {
                if (!(o instanceof AbstractPolicy)) {
                    throw new IllegalArgumentException("non-AbstractPolicy in policies");
                }
                list.add(new PolicyCombinerElement((AbstractPolicy)o));
            }
        }
        this.setChildren(list);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policyElements, String defaultVersion, Set obligations, List parameters) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, parameters);
        if (policyElements != null) {
            for (Object o : policyElements) {
                if (o instanceof PolicyCombinerElement) continue;
                throw new IllegalArgumentException("non-AbstractPolicy in policies");
            }
        }
        this.setChildren(policyElements);
    }

    private PolicySet(Node root, PolicyFinder finder) throws ParsingException {
        super(root, "PolicySet", "PolicyCombiningAlgId");
        ArrayList<AbstractPolicy> policies = new ArrayList<AbstractPolicy>();
        HashMap policyParameters = new HashMap();
        HashMap policySetParameters = new HashMap();
        PolicyMetaData metaData = this.getMetaData();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("PolicySet")) {
                policies.add(PolicySet.getInstance(child, finder));
                continue;
            }
            if (name.equals("Policy")) {
                policies.add(Policy.getInstance(child));
                continue;
            }
            if (name.equals("PolicySetIdReference")) {
                policies.add(PolicyReference.getInstance(child, finder, metaData));
                continue;
            }
            if (name.equals("PolicyIdReference")) {
                policies.add(PolicyReference.getInstance(child, finder, metaData));
                continue;
            }
            if (name.equals("PolicyCombinerParameters")) {
                this.paramaterHelper(policyParameters, child, "Policy");
                continue;
            }
            if (!name.equals("PolicySetCombinerParameters")) continue;
            this.paramaterHelper(policySetParameters, child, "PolicySet");
        }
        ArrayList<PolicyCombinerElement> elements = new ArrayList<PolicyCombinerElement>();
        for (AbstractPolicy policy : policies) {
            List list = null;
            if (policy instanceof Policy) {
                list = (List)policyParameters.remove(policy.getId().toString());
            } else if (policy instanceof PolicySet) {
                list = (List)policySetParameters.remove(policy.getId().toString());
            } else {
                PolicyReference ref = (PolicyReference)policy;
                String id = ref.getReference().toString();
                list = ref.getReferenceType() == 0 ? (List)policyParameters.remove(id) : (List)policySetParameters.remove(id);
            }
            elements.add(new PolicyCombinerElement(policy, list));
        }
        if (!policyParameters.isEmpty()) {
            throw new ParsingException("Unmatched parameters in Policy");
        }
        if (!policySetParameters.isEmpty()) {
            throw new ParsingException("Unmatched parameters in PolicySet");
        }
        this.setChildren(elements);
    }

    private void paramaterHelper(HashMap parameters, Node root, String prefix) throws ParsingException {
        String ref = root.getAttributes().getNamedItem(prefix + "IdRef").getNodeValue();
        if (parameters.containsKey(ref)) {
            List list = (List)parameters.get(ref);
            this.parseParameters(list, root);
        } else {
            ArrayList list = new ArrayList();
            this.parseParameters(list, root);
            parameters.put(ref, list);
        }
    }

    private void parseParameters(List parameters, Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("CombinerParameter")) continue;
            parameters.add(CombinerParameter.getInstance(node));
        }
    }

    public static PolicySet getInstance(Node root) throws ParsingException {
        return PolicySet.getInstance(root, null);
    }

    public static PolicySet getInstance(Node root, PolicyFinder finder) throws ParsingException {
        if (!root.getNodeName().equals("PolicySet")) {
            throw new ParsingException("Cannot create PolicySet from root of type " + root.getNodeName());
        }
        return new PolicySet(root, finder);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        String version;
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<PolicySet PolicySetId=\"" + this.getId().toString() + "\" PolicyCombiningAlgId=\"" + this.getCombiningAlg().getIdentifier().toString() + "\">");
        indenter.in();
        String nextIndent = indenter.makeString();
        String description = this.getDescription();
        if (description != null) {
            out.println(nextIndent + "<Description>" + description + "</Description>");
        }
        if ((version = this.getDefaultVersion()) != null) {
            out.println("<PolicySetDefaults><XPathVersion>" + version + "</XPathVersion></PolicySetDefaults>");
        }
        this.getTarget().encode(output, indenter);
        this.encodeCommonElements(output, indenter);
        indenter.out();
        out.println(indent + "</PolicySet>");
    }
}

